% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{run_annotators}
\alias{run_annotators}
\title{Run the annotation pipeline on a set of documents}
\usage{
run_annotators(input, file = NULL, output_dir = NULL, load = TRUE,
  keep = TRUE, as_strings = FALSE, doc_id_offset = 0L, backend = NULL,
  meta = NULL)
}
\arguments{
\item{input}{either a vector of file names to parse, or a
character vector with one document in each
element. Specify the latter with the
as_string flag.}

\item{file}{character. Location to store a compressed R
object containing the results.
If NULL, the default, no such compressed
object will be stored.}

\item{output_dir}{path to the directory where the raw output
should be stored. Will be created if it does not
exist. Files currently in this location will
be overwritten. If NULL, the default, it uses a
temporary directory.
Not to be confused with \code{file}, this
location stores the raw csv
files rather than a compressed dataset.}

\item{load}{logical. Once parsed, should the data be read into
R as an annotation object?}

\item{keep}{logical. Once parsed, should the files be kept
on disk in \code{output_dir}?}

\item{as_strings}{logical. Is the data given to \code{input} the
actual document text rather
than file names?}

\item{doc_id_offset}{integer. The first document id to use. Defaults
to 0.}

\item{backend}{which backend to use. Will default to the last
model to be initalized.}

\item{meta}{an optional data frame to bind to the document
table}
}
\value{
if \code{load} is true, an object of class \code{annotation}.
         Otherwise, a character vector giving the output location of
         the files.
}
\description{
Runs the clean_nlp annotators over a given corpus of text
using either the R, Java, or Python backend. The details for
which annotators to run and how to run them are specified
by using one of: \code{\link{init_tokenizers}},
\code{\link{init_spaCy}}, or \code{\link{init_coreNLP}}.
}
\examples{
\dontrun{
annotation <- run_annotators("path/to/corpus/directory")
}

}
\references{
Manning, Christopher D., Mihai Surdeanu, John Bauer, Jenny Finkel,
  Steven J. Bethard, and David McClosky. 2014.
  \href{http://nlp.stanford.edu/pubs/StanfordCoreNlp2014.pdf}{The
        Stanford CoreNLP Natural Language Processing Toolkit}.
  In: \emph{Proceedings of the 52nd Annual Meeting of the Association
            for Computational Linguistics: System Demonstrations,
            pp. 55-60.}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
