/*
 * Decompiled with CFR 0.152.
 */
package edu.richmond.nlp;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;

public class CSVNamedEntityDocumentWriter {
    public String docID = "";
    public String header = "";

    public CSVNamedEntityDocumentWriter(String docID) {
        this.docID = docID;
        this.header = String.format("id,sid,tid,tid_end,entity_type,entity,entity_normalized%n", new Object[0]);
    }

    public String print(CoreMap sentence) {
        StringBuilder sb = new StringBuilder();
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        String entity = "";
        String entityNorm = "";
        String entityType = "";
        int tid = 0;
        int tidEnd = 0;
        int sid = 0;
        for (CoreLabel token : tokens) {
            String ner = token.getString(CoreAnnotations.NamedEntityTagAnnotation.class, "");
            if (ner.equals("O")) {
                if (entity.equals("")) continue;
                sb.append(String.format("doc%s,%d,%d,%d,%s,\"%s\",\"%s\"%n", this.docID, sid, tid, tidEnd, entityType, entity, entityNorm));
                entity = "";
                entityType = "";
                continue;
            }
            if (ner.equals("")) continue;
            if (entity.equals("")) {
                tid = token.index();
                sid = token.sentIndex();
                entityNorm = token.getString(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, "");
                entity = token.word();
            } else {
                entity = entity + " " + token.word();
            }
            tidEnd = token.index();
            entityType = ner;
        }
        if (!entity.equals("")) {
            sb.append(String.format("doc%s,%d,%d,%d,%s,\"%s\",\"%s\"%n", this.docID, sid + 1, tid, tidEnd, entityType, entity, entityNorm));
        }
        return sb.toString();
    }

    public void setDocID(String docID) {
        this.docID = docID;
    }
}

