% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend_spacy.R
\name{cnlp_init_spacy}
\alias{cnlp_init_spacy}
\title{Interface for initializing the spacy backend}
\usage{
cnlp_init_spacy(model_name = NULL, entity_flag = TRUE,
  vector_flag = FALSE)
}
\arguments{
\item{model_name}{string giving the model name for the Python/spacy
backend. Defaults to "en_core_web_sm" (English) if
set to NULL.}

\item{entity_flag}{boolean. Should named entities be identified.}

\item{vector_flag}{boolean. Should word vectors be computed and saved.}
}
\description{
This function must be run before annotating text with
the spacy backend. It sets the properties for the
spacy engine and loads the file using the R to Python
interface provided by reticulate.
}
\examples{
\dontrun{
cnlp_init_spacy(vector_flag = TRUE)
}

}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
