% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_name_standardization.R
\name{standardize_column_names}
\alias{standardize_column_names}
\title{Standardize column names of a data frame or linelist}
\usage{
standardize_column_names(data, keep = NULL, rename = NULL)
}
\arguments{
\item{data}{The input data frame or linelist.}

\item{keep}{A vector of column names to maintain as they are. When dealing
with a linelist, this can be set to \code{linelist_tags}, to maintain the
tagged column names. The Default is \code{NULL}.}

\item{rename}{A named vector of column names to be renamed. This should be in
the form of \code{c(new_name1 = "old_name1", new_name2 = "old_name2")} for
example.}
}
\value{
A data frame or linelist with easy to work with column names.
}
\description{
All columns names will be reformatted to use the snakecase. When the
conversion to snakecase does not work as expected, use the \code{keep} and/or
\code{rename} arguments to reformat the column name properly.
}
\examples{
# do not rename 'date.of.admission'
cleaned_data <- standardize_column_names(
  data = readRDS(system.file("extdata", "test_df.RDS",
                             package = "cleanepi")),
  keep = "date.of.admission"
)

# do not rename 'date.of.admission', but rename 'dateOfBirth' and 'sex' to
# 'DOB' and 'gender' respectively
cleaned_data <- standardize_column_names(
  data   = readRDS(system.file("extdata", "test_df.RDS",
                               package = "cleanepi")),
  keep   = "date.of.admission",
  rename = c(DOB = "dateOfBirth", gender = "sex")
)

}
