% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crayon.R
\name{combine_ansi_styles}
\alias{combine_ansi_styles}
\title{Combine two or more ANSI styles}
\usage{
combine_ansi_styles(...)
}
\arguments{
\item{...}{The styles to combine. For character strings, the
\code{\link[=make_ansi_style]{make_ansi_style()}} function is used to create a style first.
They will be applied from right to left.}
}
\value{
The combined style function.
}
\description{
Combine two or more styles or style functions into a new style function
that can be called on strings to style them.
}
\details{
It does not usually make sense to combine two foreground
colors (or two background colors), because only the first one
applied will be used.

It does make sense to combine different kind of styles,
e.g. background color, foreground color, bold font.
}
\examples{
## Use style names
alert <- combine_ansi_styles("bold", "red4")
cat(alert("Warning!"), "\\n")

## Or style functions
alert <- combine_ansi_styles(style_bold, col_red, bg_cyan)
cat(alert("Warning!"), "\\n")

## Combine a composite style
alert <- combine_ansi_styles(
  "bold",
  combine_ansi_styles("red", bg_cyan))
cat(alert("Warning!"), "\\n")
}
\seealso{
Other ANSI styling: \code{\link{ansi-styles}},
  \code{\link{make_ansi_style}}
}
\concept{ANSI styling}
