% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tty.R
\name{is_dynamic_tty}
\alias{is_dynamic_tty}
\title{Detect whether a stream supports \code{\\r} (Carriage return)}
\usage{
is_dynamic_tty(stream = stderr())
}
\arguments{
\item{stream}{The stream to inspect, an R connection object.
Note that it defaults to the standard \emph{error} stream, since
informative messages are typically printed there.}
}
\description{
In a terminal, \code{\\r} moves the cursor to the first position of the
same line. It is also supported by most R IDEs. \code{\\r} is typically
used to achive a more dynamic, less cluttered user interface, e.g.
to create progress bars.
}
\details{
If the output is directed to a file, then \code{\\r} characters are typically
unwanted. This function detects if \code{\\r} can be used for the given
stream or not.

The detection mechanism is as follows:
\enumerate{
\item If the \code{cli.dynamic} option is set to \code{TRUE}, \code{TRUE} is returned.
\item If the \code{cli.dynamic} option is set to anything else, \code{FALSE} is
returned.
\item If the \code{R_CLI_DYNAMIC} environment variable is not empty and set to
the string \code{"true"}, \code{"TRUE"} or \code{"True"}, \code{TRUE} is returned.
\item If \code{R_CLI_DYNAMIC} is not empty and set to anything else, \code{FALSE} is
returned.
\item If the stream is a terminal, then \code{TRUE} is returned.
\item If the stream is hte standard output or error within RStudio,
the macOS R app, or RKWard IDE, \code{TRUE} is returned.
\item Otherwise \code{FALSE} is returned.
}
}
\examples{
is_dynamic_tty()
is_dynamic_tty(stdout())
}
\seealso{
Other terminal capabilities: \code{\link{is_ansi_tty}}
}
\concept{terminal capabilities}
