% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crayonex.R
\name{ansi_align}
\alias{ansi_align}
\title{Align an ANSI colored string}
\usage{
ansi_align(
  text,
  width = getOption("width"),
  align = c("left", "center", "right"),
  type = "width"
)
}
\arguments{
\item{text}{The character vector to align.}

\item{width}{Width of the field to align in.}

\item{align}{Whether to align \code{"left"}, \code{"center"} or \code{"right"}.}

\item{type}{Passed on to \code{\link[=ansi_nchar]{ansi_nchar()}} and there to \code{\link[=nchar]{nchar()}}}
}
\value{
The aligned character vector.
}
\description{
Align an ANSI colored string
}
\examples{
ansi_align(col_red("foobar"), 20, "left")
ansi_align(col_red("foobar"), 20, "center")
ansi_align(col_red("foobar"), 20, "right")
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()}
}
\concept{ANSI string operations}
