% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_ul}
\alias{cli_ul}
\title{Unordered CLI list}
\usage{
cli_ul(
  items = NULL,
  id = NULL,
  class = NULL,
  .close = TRUE,
  .auto_close = TRUE,
  .envir = parent.frame()
)
}
\arguments{
\item{items}{If not \code{NULL}, then a character vector. Each element of
the vector will be one list item, and the list container will be
closed by default (see the \code{.close} argument).}

\item{id}{Id of the list container. Can be used for closing it with
\code{\link[=cli_end]{cli_end()}} or in themes. If \code{NULL}, then an id is generated and
returned invisibly.}

\item{class}{Class of the list container. Can be used in themes.}

\item{.close}{Whether to close the list container if the \code{items} were
specified. If \code{FALSE} then new items can be added to the list.}

\item{.auto_close}{Whether to close the container, when the calling
function finishes (or \code{.envir} is removed, if specified).}

\item{.envir}{Environment to evaluate the glue expressions in. It is
also used to auto-close the container if \code{.auto_close} is \code{TRUE}.}
}
\value{
The id of the new container element, invisibly.
}
\description{
An unordered list is a container, see \link{containers}.
}
\details{
\subsection{Adding all items at once}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_ul(c("one", "two", "three"))
\}
fun()
}\if{html}{\out{</div>}}

\if{html}{\figure{cli-ul.svg}}
}

\subsection{Adding items one by one}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_ul()
  cli_li("\{.emph one\}")
  cli_li("\{.emph two\}")
  cli_li("\{.emph three\}")
  cli_end()
\}
fun()
}\if{html}{\out{</div>}}

\if{html}{\figure{cli-ul-2.svg}}
}
}
