% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box-styles.R, R/boxes.R
\name{list_border_styles}
\alias{list_border_styles}
\alias{boxx}
\title{Draw a banner-like box in the console}
\usage{
list_border_styles()

boxx(
  label,
  header = "",
  footer = "",
  border_style = "single",
  padding = 1,
  margin = 0,
  float = c("left", "center", "right"),
  col = NULL,
  background_col = NULL,
  border_col = col,
  align = c("left", "center", "right"),
  width = console_width()
)
}
\arguments{
\item{label}{Label to show, a character vector. Each element will be
in a new line. You can color it using the \verb{col_*}, \verb{bg_*} and
\verb{style_*} functions, see \link[=ansi-styles]{ANSI styles} and the examples
below.}

\item{header}{Text to show on top border of the box. If too long,
it will be cut.}

\item{footer}{Text to show on the bottom border of the box. If too long,
it will be cut.}

\item{border_style}{String that specifies the border style.
\code{list_border_styles} lists all current styles.}

\item{padding}{Padding within the box. Either an integer vector of
four numbers (bottom, left, top, right), or a single number \code{x}, which
is interpreted as \code{c(x, 3*x, x, 3*x)}.}

\item{margin}{Margin around the box. Either an integer vector of four
numbers (bottom, left, top, right), or a single number \code{x}, which is
interpreted as \code{c(x, 3*x, x, 3*x)}.}

\item{float}{Whether to display the box on the \code{"left"}, \code{"center"}, or
the \code{"right"} of the screen.}

\item{col}{Color of text, and default border color. Either a style
function (see \link[=ansi-styles]{ANSI styles}) or a color name that is
passed to \code{\link[=make_ansi_style]{make_ansi_style()}}.}

\item{background_col}{Background color of the inside of the box.
Either a style function (see \link[=ansi-styles]{ANSI styles}), or a color
name which will be used in \code{\link[=make_ansi_style]{make_ansi_style()}} to create a
\emph{background} style (i.e. \code{bg = TRUE} is used).}

\item{border_col}{Color of the border. Either a style function
(see \link[=ansi-styles]{ANSI styles}) or a color name that is passed to
\code{\link[=make_ansi_style]{make_ansi_style()}}.}

\item{align}{Alignment of the label within the box: \code{"left"},
\code{"center"}, or \code{"right"}.}

\item{width}{Width of the screen, defaults to \code{\link[=console_width]{console_width()}}.}
}
\description{
Draw a banner-like box in the console
}
\details{
\subsection{Defaults}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boxx("Hello there!")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ┌──────────────────┐                                                            
#> │                  │                                                            
#> │   Hello there!   │                                                            
#> │                  │                                                            
#> └──────────────────┘                                                            
</pre></div>
}}

}

\subsection{Change border style}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boxx("Hello there!", border_style = "double")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ╔══════════════════╗                                                            
#> ║                  ║                                                            
#> ║   Hello there!   ║                                                            
#> ║                  ║                                                            
#> ╚══════════════════╝                                                            
</pre></div>
}}

}

\subsection{Multiple lines}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boxx(c("Hello", "there!"), padding = 1)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ┌────────────┐                                                                  
#> │            │                                                                  
#> │   Hello    │                                                                  
#> │   there!   │                                                                  
#> │            │                                                                  
#> └────────────┘                                                                  
</pre></div>
}}

}

\subsection{Padding}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boxx("Hello there!", padding = 1)
boxx("Hello there!", padding = c(1, 5, 1, 5))
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ┌──────────────────┐                                                            
#> │                  │                                                            
#> │   Hello there!   │                                                            
#> │                  │                                                            
#> └──────────────────┘                                                            
#> ┌──────────────────────┐                                                        
#> │                      │                                                        
#> │     Hello there!     │                                                        
#> │                      │                                                        
#> └──────────────────────┘                                                        
</pre></div>
}}

}

\subsection{Floating}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boxx("Hello there!", padding = 1, float = "center")
boxx("Hello there!", padding = 1, float = "right")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                           ┌──────────────────┐                                  
#>                           │                  │                                  
#>                           │   Hello there!   │                                  
#>                           │                  │                                  
#>                           └──────────────────┘                                  
#>                                                   ┌──────────────────┐          
#>                                                   │                  │          
#>                                                   │   Hello there!   │          
#>                                                   │                  │          
#>                                                   └──────────────────┘          
</pre></div>
}}

}

\subsection{Text color}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boxx(col_cyan("Hello there!"), padding = 1, float = "center")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#>                           ┌──────────────────┐                                  
#>                           │                  │                                  
#>                           │   <span style="color: #2AA198;">Hello there!</span>   │                                  
#>                           │                  │                                  
#>                           └──────────────────┘                                  
</pre></div>
}}

}

\subsection{Background color}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boxx("Hello there!", padding = 1, background_col = "brown")
boxx("Hello there!", padding = 1, background_col = bg_red)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ┌──────────────────┐                                                            
#> │<span style="background-color: #990000;">                  </span>│                                                            
#> │<span style="background-color: #990000;">   Hello there!   </span>│                                                            
#> │<span style="background-color: #990000;">                  </span>│                                                            
#> └──────────────────┘                                                            
#> ┌──────────────────┐                                                            
#> │<span style="background-color: #DC322F;">                  </span>│                                                            
#> │<span style="background-color: #DC322F;">   Hello there!   </span>│                                                            
#> │<span style="background-color: #DC322F;">                  </span>│                                                            
#> └──────────────────┘                                                            
</pre></div>
}}

}

\subsection{Border color}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boxx("Hello there!", padding = 1, border_col = "green")
boxx("Hello there!", padding = 1, border_col = col_red)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #859900;">┌──────────────────┐</span>                                                            
#> <span style="color: #859900;">│</span>                  <span style="color: #859900;">│</span>                                                            
#> <span style="color: #859900;">│</span>   Hello there!   <span style="color: #859900;">│</span>                                                            
#> <span style="color: #859900;">│</span>                  <span style="color: #859900;">│</span>                                                            
#> <span style="color: #859900;">└──────────────────┘</span>                                                            
#> <span style="color: #DC322F;">┌──────────────────┐</span>                                                            
#> <span style="color: #DC322F;">│</span>                  <span style="color: #DC322F;">│</span>                                                            
#> <span style="color: #DC322F;">│</span>   Hello there!   <span style="color: #DC322F;">│</span>                                                            
#> <span style="color: #DC322F;">│</span>                  <span style="color: #DC322F;">│</span>                                                            
#> <span style="color: #DC322F;">└──────────────────┘</span>                                                            
</pre></div>
}}

}

\subsection{Label alignment}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{boxx(c("Hi", "there", "you!"), padding = 1, align = "left")
boxx(c("Hi", "there", "you!"), padding = 1, align = "center")
boxx(c("Hi", "there", "you!"), padding = 1, align = "right")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> ┌───────────┐                                                                   
#> │           │                                                                   
#> │   Hi      │                                                                   
#> │   there   │                                                                   
#> │   you!    │                                                                   
#> │           │                                                                   
#> └───────────┘                                                                   
#> ┌───────────┐                                                                   
#> │           │                                                                   
#> │     Hi    │                                                                   
#> │   there   │                                                                   
#> │    you!   │                                                                   
#> │           │                                                                   
#> └───────────┘                                                                   
#> ┌───────────┐                                                                   
#> │           │                                                                   
#> │      Hi   │                                                                   
#> │   there   │                                                                   
#> │    you!   │                                                                   
#> │           │                                                                   
#> └───────────┘                                                                   
</pre></div>
}}

}

\subsection{A very customized box}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{star <- symbol$star
label <- c(paste(star, "Hello", star), "  there!")
boxx(
  col_white(label),
  border_style="round",
  padding = 1,
  float = "center",
  border_col = "tomato3",
  background_col="darkolivegreen"
)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> <span style="color: #cc3333;">                           ╭───────────────╮</span>                                    
#>                            <span style="color: #cc3333;">│</span><span style="background-color: #336633;">               </span><span style="color: #cc3333;">│</span>                                    
#>                            <span style="color: #cc3333;">│</span><span style="background-color: #336633;">   </span><span style="color: #EEE8D5;background-color: #336633;">★ Hello ★</span><span style="background-color: #336633;">   </span><span style="color: #cc3333;">│</span>                                    
#>                            <span style="color: #cc3333;">│</span><span style="background-color: #336633;">   </span><span style="color: #EEE8D5;background-color: #336633;">  there!</span><span style="background-color: #336633;">    </span><span style="color: #cc3333;">│</span>                                    
#>                            <span style="color: #cc3333;">│</span><span style="background-color: #336633;">               </span><span style="color: #cc3333;">│</span>                                    
#> <span style="color: #cc3333;">                           ╰───────────────╯</span>                                    
</pre></div>
}}

}
}
\section{About fonts and terminal settings}{

The boxes might or might not look great in your terminal, depending
on the box style you use and the font the terminal uses. We found that
the Menlo font looks nice in most terminals an also in Emacs.

RStudio currently has a line height greater than one for console output,
which makes the boxes ugly.
}

