% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clickstream.r
\name{as.clickstreams}
\alias{as.clickstreams}
\title{Converts a character vector or a character list into a clickstream list.}
\usage{
as.clickstreams(obj, sep = ",", header = TRUE)
}
\arguments{
\item{obj}{The character vector or character list which will be converted into a clickstream list.
Each line of the vector must represent exactly one click stream.}

\item{sep}{The character separating clicks (default is \dQuote{,}).}

\item{header}{A logical flag indicating whether the first entry of each entry
in the character vector is the name of the clickstream.}
}
\value{
A list of clickstreams. Each element is a vector of characters
representing the clicks. The name of each list element is either extracted from the
character vector or a unique number.
}
\description{
Converts a character vector or a character list into a clickstream list. Note that non-alphanumeric characters will be removed.
}
\examples{

clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
cls <- as.clickstreams(clickstreams, header = TRUE)
print(cls)

}
\seealso{
\code{\link{print.Clickstreams}}, \code{\link{randomClickstreams}}
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
