% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clickstream.r
\name{as.moltenTransactions}
\alias{as.moltenTransactions}
\title{Coerces a Clickstream Object to a Transactions Object}
\usage{
as.moltenTransactions(clickstreamList)
}
\arguments{
\item{clickstreamList}{A list of clickstreams.}
}
\value{
An instance of the old class \code{\link[arules]{transactions}}
}
\description{
Coerces a \code{Clickstream} object to a \code{transactions} object.
}
\examples{

clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
cls <- as.clickstreams(clickstreams, header = TRUE)
trans <- as.moltenTransactions(cls)

}
\seealso{
\code{\link{frequencies}}
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
