% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfData-plotMethods.R
\docType{methods}
\name{plot,cfRain,missing-method}
\alias{plot,cfRain,missing-method}
\alias{plot.cfRain}
\title{Plot Rain Time series}
\usage{
\S4method{plot}{cfRain,missing}(x, y, include_runoff = TRUE,
  ggtheme = c("grey", "gray", "bw", "linedraw", "light", "minimal",
  "classic"), scales = c("fixed", "free_x", "free_y", "free"), n_col = 1,
  ...)
}
\arguments{
\item{x}{a \code{cfRain} object.}

\item{y}{missing.}

\item{include_runoff}{a logical indicating whether to plot the soil moisture
deficit and runoff as well as the rainfall, if the data
is available (default \code{TRUE}).}

\item{ggtheme}{character string (partially) matching the
\code{\link[ggplot2]{ggtheme}} to be used for plotting, see
'Theme Selection' below.}

\item{scales}{character string partially matching the \code{scales} argument
in the \code{link[ggplot2]{facet_wrap}} function.}

\item{n_col}{the number of columns of plots (default 1).}

\item{...}{further arguments passed to \code{\link[ggplot2]{theme}}.}
}
\description{
Plot the amount of rainfall (mm) through time, with optional available soil
water capacity and runoff amounts (if applicable).
}
\details{
When there is a rain event, the amount of runoff, if any, is dependent on how
much capacity the soil has available for more water. If there is no available
water capacity left in the soil then more rain will lead to a runoff event.
If \code{include_runoff = TRUE}, the available water capacity is plotted as
negative values and the runoff as positive values to signify this negative
relationship.
}
\examples{
\dontrun{
# Retrieve public rain data for a month from CliFlo (at Reefton Ews station)
reefton_rain = cf_query(cf_user(), cf_datatype(3, 1, 1), cf_station(),
                        start_date = "2012-08-01-00",
                        end_date = "2012-09-01-00")

class(reefton_rain) # cfRain object

# Plot the rain data using the defaults
plot(reefton_rain)

# Change the ggtheme and enlarge the text
library(ggplot2) # for element_text()
plot(reefton_rain, ggtheme = "bw", text = element_text(size = 16))

# Save the plot as a png to the current working directory
library(ggplot2) # for ggsave()
ggsave("my_rain_plot.png")
}
}
\seealso{
\code{\link{plot,cfDataList,missing-method}} for general
  information on default plotting of \code{cfData} and \code{cfDataList}
  objects, and the links within. See \code{\link{cf_query}} for creating
  \code{cfRain} objects.

  Refer to \code{\link[ggplot2]{theme}} for more possible arguments to pass
  to these methods.
}
