% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfQuery.R
\name{cf_query}
\alias{cf_query}
\title{Retrieve Data from the National Climate Database}
\usage{
cf_query(user, datatype, station, start_date, end_date = now(tz),
  date_format = "ymd_h", tz = "Pacific/Auckland", quiet = FALSE)
}
\arguments{
\item{user}{a \code{\link{cfUser}} object.}

\item{datatype}{a \code{\link{cfDatatype}} object containing the datatypes to
be retrieved.}

\item{station}{a \code{\link{cfStation}} object containing the stations where
the datatypes will be retrieved from.}

\item{start_date}{a character, Date or POSIXt object indicating the start
date. If a character string is supplied the date format
should be in the form \code{yyyy-mm-dd-hh} unless
\code{date_format} is specified.}

\item{end_date}{same as \code{start_date}. Defaults to
\code{\link[lubridate]{now}}.}

\item{date_format}{a character string matching one of \code{"ymd_h"},
\code{"mdy_h"}, \code{"ydm_h"} or \code{"dmy_h"}
representing the \code{\link[lubridate]{lubridate-package}}
date parsing function.}

\item{tz}{the timezone for which the start and end dates refer to. Conversion
to Pacific/Auckland time is done automatically through the
\code{\link[lubridate]{with_tz}} function. Defaults to
"Pacific/Auckland".}

\item{quiet}{logical. When \code{TRUE} the function evaluates without
displaying customary messages. Messages from CliFlo are still
displayed.}
}
\value{
a \code{cfData} or \code{cfDataList} object.
}
\description{
Query the National Climate Database via CliFlo based on the \pkg{clifro} user
and selected datatypes, stations and dates.
}
\details{
The \code{cf_query} function is used to combine the \pkg{clifro} user
(\code{\link{cfUser}}), along with the desired datatypes
(\code{\link{cfDatatype}}) and stations (\code{\link{cfStation}}). The query
is 'built up' using these objects, along with the necessary dates. The
function then uses all these data to query the National Climate Database via
the CliFlo web portal and returns one of the many \code{cfData}
objects if one dataframe is returned, or a \code{cfDataList} object if
there is more than one dataframe returned from CliFlo. If a \code{cfDataList}
is returned, each element in the list is a subclass of the \code{cfData}
class, see the 'cfData Subclasses' section.
}
\section{CfData Subclasses}{


There are 8 \code{cfData} subclasses that are returned from \code{cf_query}
depending on the datatype requested. Each of these subclasses have default
\code{plot} methods for usability and efficiency in exploring and plotting
\pkg{clifro} data.

The following table summarises these subclasses and how they are created, see
also the examples on how to automatically create some of these subclasses.

\tabular{ll}{
\strong{Subclass} \tab \strong{CliFlo Datatype}\cr
cfWind \tab Any 'Wind' data \cr
cfRain \tab Any 'Precipitation' data \cr
cfScreen Obs \tab 'Temperature and Humidity' data measured in a standard screen \cr
cfTemp \tab Maximum and minimum 'Temperature and Humidity' data \cr
cfEarthTemp \tab 'Temperature and Humidity' data at a given depth \cr
cfSunshine \tab Any 'Sunshine & Radiation' data \cr
cfPressure \tab Any 'Pressure' data \cr
cfOther \tab Any other CliFlo 'Daily and Hourly Observations' \cr
}
}

\examples{
\dontrun{
# Retrieve daily rain data from Reefton Ews
daily.rain = cf_query(cf_user("public"), cf_datatype(3, 1, 1),
                      cf_station(), "2012-01-01 00")
daily.rain

# returns a cfData object as there is only one datatype
class(daily.rain) # 'cfRain' object - inherits 'cfData'

# Look up the help page for cfRain plot methods
?plot.cfRain

# Retrieve daily rain and wind data from Reefton Ews

daily.dts = cf_query(cf_user("public"),
                     cf_datatype(c(2, 3), c(1, 1), list(4, 1), c(1, NA)),
                     cf_station(), "2012-01-01 00", "2013-01-01 00")
daily.dts

# returns a cfDataList object as there is more than one datatype. Each
# element of the cfDataList is an object inheriting from the cfData class.
class(daily.dts)     # cfDataList
class(daily.dts[1])  # cfRain
class(daily.dts[2])  # cfWind

# Create a cfSunshine object (inherits cfData)
# Retrieve daily global radiation data at Reefton Ews
rad.data = cf_query(cf_user(), cf_datatype(5,2,1), cf_station(),
                    "2012-01-01 00")
rad.data

# The cf_query function automatically creates the appropriate cfData subclass
class(rad.data)

# The advantage of having these subclasses is that it makes plotting very easy
plot(rad.data)
plot(daily.rain)
plot(daily.rain, include_runoff = FALSE)
plot(daily.dts)
plot(daily.dts, 2)
}
}
\seealso{
\code{\link{cf_user}}, \code{\link{cf_datatype}} and
  \code{\link{cf_station}} for creating the objects needed for a query. See
  \code{\link{plot,cfDataList,missing-method}} for general information on
  default plotting of \code{cfData} and \code{cfDataList} objects, and the
  links within.
}
