% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_stations.R
\name{aemet_stations}
\alias{aemet_stations}
\title{AEMET stations}
\usage{
aemet_stations(verbose = FALSE, return_sf = FALSE)
}
\arguments{
\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{sf} spatial object? If \code{FALSE}
(the default value) it returns a tibble. Note that you need to
have the \code{sf} package installed.}
}
\value{
A tibble or a \code{sf} object
}
\description{
Get AEMET stations.
}
\note{
Code modified from project \url{https://github.com/SevillaR/aemet}
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
# Run this example only if AEMET_API_KEY is set

if (aemet_detect_api_key()) {
  library(tibble)
  stations <- aemet_stations()
  stations
}
}
\seealso{
Other aemet_api_data: 
\code{\link{aemet_daily_clim}()},
\code{\link{aemet_extremes_clim}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_monthly}},
\code{\link{aemet_normal}}
}
\concept{aemet_api_data}
