% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_api_query.R
\name{get_data_aemet}
\alias{get_data_aemet}
\alias{get_metadata_aemet}
\title{Client tool for AEMET API}
\source{
\url{https://opendata.aemet.es/dist/index.html}
}
\usage{
get_data_aemet(apidest, verbose = FALSE)

get_metadata_aemet(apidest, verbose = FALSE)
}
\arguments{
\item{apidest}{Character string as destination URL. See
\url{https://opendata.aemet.es/dist/index.html}.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}
}
\value{
A tibble (if possible) or the results of the query as provided by
\code{\link[httr:content]{httr::content()}}.
}
\description{
Client tool to get data and metadata from AEMET and convert json to tibble.
}
\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Run this example only if AEMET_API_KEY is detected

url <- "/api/valores/climatologicos/inventarioestaciones/todasestaciones"

get_data_aemet(url)


# Metadata

get_metadata_aemet(url)

# We can get data from any API endpoint

# Plain text

plain <- get_data_aemet("/api/prediccion/nacional/hoy")

cat(plain)

# An image

image <- get_data_aemet("/api/mapasygraficos/analisis")

# Write and read
tmp <- tempfile(fileext = ".gif")

writeBin(image, tmp)

gganimate::gif_file(tmp)
\dontshow{\}) # examplesIf}
}
\seealso{
Some examples on how to use these functions on
\code{vignette("extending-climaemet")}.
}
\concept{aemet_api}
