% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aemet_extremes.R
\name{aemet_extremes_clim}
\alias{aemet_extremes_clim}
\title{Extreme values for a station}
\usage{
aemet_extremes_clim(
  station = NULL,
  parameter = "T",
  verbose = FALSE,
  return_sf = FALSE
)
}
\arguments{
\item{station}{Character string with station identifier code(s)
(see \code{\link[=aemet_stations]{aemet_stations()}})}

\item{parameter}{Character string as temperature ("T"),
precipitation ("P") or wind ("V") parameter.}

\item{verbose}{Logical \code{TRUE/FALSE}. Provides information about the flow of
information between the client and server.}

\item{return_sf}{Logical \code{TRUE} or \code{FALSE}.
Should the function return an \code{sf} spatial object? If \code{FALSE}
(the default value) it returns a tibble. Note that you need to
have the \code{sf} package installed.}
}
\value{
A tibble or a \code{sf} object
}
\description{
Get recorded extreme values for a station.
}
\section{API Key}{
You need to set your API Key globally using \code{\link[=aemet_api_key]{aemet_api_key()}}.
}

\examples{
\dontshow{if (aemet_detect_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(tibble)
obs <- aemet_extremes_clim(c("9434", "3195"))
glimpse(obs)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=aemet_api_key]{aemet_api_key()}}

Other aemet_api_data: 
\code{\link{aemet_daily_clim}()},
\code{\link{aemet_forecast_daily}()},
\code{\link{aemet_last_obs}()},
\code{\link{aemet_monthly}},
\code{\link{aemet_normal}},
\code{\link{aemet_stations}()}
}
\concept{aemet_api_data}
