% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheroid_dist.R
\name{spheroid_dist}
\alias{spheroid_dist}
\title{Distance between two points on a spheroid}
\usage{
spheroid_dist(p1, p2)
}
\arguments{
\item{p1}{coordinates of the first point in decimal degrees (LON, LAT)}

\item{p2}{coordinates of the second point in decimal degrees (LON, LAT)}
}
\value{
numerical vector with distance between two locations (in kilometers)
}
\description{
Calculate the distance between two points on the surface of a spheroid
using Vincenty's formula. This function can be used when GIS libraries
for calculating distance are not available.
}
\examples{
 p1 = c(18.633333, 54.366667) # longitude and latitude for Gdansk, PL
 p2 = c(17.016667, 54.466667) # longitude and latitude for Slupsk, PL
 spheroid_dist(p1, p2)
 
}
