% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worldclim.R
\name{worldclim}
\alias{worldclim}
\title{Download WorldClim climate data}
\usage{
worldclim(output_dir, location, var = "all", ...)
}
\arguments{
\item{output_dir}{Character (e.g., \code{"../Desktop/chelsa"}). Pathway to where
the data will be stored.}

\item{location}{A \code{"sp"}, \code{"sf"} polygon or point object. See
\link[sf:st]{sf::st_polygon} to make polygons and \link[sf:st_as_sf]{sf::st_as_sf} to make point
objects.}

\item{var, \dots}{Arguments to \code{\link[=download.file]{download.file()}} to control file download.
.}
}
\value{
\code{worldclim()} is called for its side effects and returns \code{NULL}.
Creates four subfolders named prec, tmax, tmin and tmean. Each folder
contains 12 GeoTiff (.tif) files, one for each month of the year for the time
period 1970–2000. Each of the files are downloaded at a spatial
resolution of 0.5 minutes of a degree. The precipitation folder contains
average monthly precipitation (mm). The tmax folder contains maximum monthly
temperature. The tmin folder contains minimum monthly
temperature. The tmean folder contains the average monthly temperature.
Temperature values are reported in °C.
}
\description{
\code{worldclim()} downloads the WorldClim V2.1 climate data for 1970–2000.
This includes monthly climate data for minimum, mean, and maximum temperature
and precipitation at a resolution of 0.5 minutes of a degree.
This function uses the \pkg{geodata} to download the worldclim tiles.
}
\examples{
\donttest{
# Download time will depend on the size of the area you wish to access
# climate data for and your internet connection speed.

# Make a polygon file
regents <- sf::st_polygon(
  list(
    cbind(
      "lon" = c(51.537, 51.525, 51.523, 51.530, 51.534, 51.537),
      "lat" = c(-0.150, -0.145, -0.156, -0.167, -0.163, -0.150)
    )
  )
)

# Create temporary file
temp_path <- tempfile()

# Download the WorldClim data
worldclim(
  output_dir = temp_path,
  location = regents
)

# Reset user options
unlink(file.path(temp_path))

}
}
\references{
{ Fick, S.E. & Hijmans, R.J. (2017). WorldClim 2: new 1km
spatial resolution climate surfaces for global land areas. \emph{International}
\emph{Journal of Climatology}. 37, 4302–4315. \doi{10.1002/joc.5086}

}
}
\seealso{
Downloading from CHELSA \code{\link[=chelsa]{chelsa()}} or a more convenient
function for downloading other climate and elevation data \code{\link[=ce_download]{ce_download()}}.
}
\author{
James L. Tsakalos and Martin R. Smith
}
