% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosswin.R
\name{crosswin}
\alias{crosswin}
\title{Test the correlation between two climate variables.}
\usage{
crosswin(xvar, xvar2, cdate, bdate, range, stat, stat2, type, refday,
  cinterval = "day", cmissing = FALSE, spatial = NULL, cohort = NULL,
  cutoff.day = NULL, cutoff.month = NULL, furthest = NULL,
  closest = NULL)
}
\arguments{
\item{xvar}{The first climate variable of interest. Please specify the parent 
environment and variable name (e.g. Climate$Temp).}

\item{xvar2}{The second climate variable of interest. Please specify the parent 
environment and variable name (e.g. Climate$Temp).}

\item{cdate}{The climate date variable (dd/mm/yyyy). Please specify the parent
environment and variable name (e.g. Climate$Date).}

\item{bdate}{The biological date variable (dd/mm/yyyy). Please specify the 
parent environment and variable name (e.g. Biol$Date).}

\item{range}{Two values signifying respectively the furthest and closest number 
of time intervals (set by cinterval) back from the cutoff date or biological record to include 
in the climate window search.}

\item{stat}{The aggregate statistic used to analyse the climate data. Can 
currently use basic R statistics (e.g. mean, min), as well as slope. 
Additional aggregate statistics can be created using the format function(x) 
(...). See FUN in \code{\link{apply}} for more detail.}

\item{stat2}{Second aggregate statistic used to analyse climate data (xvar2). Can 
currently use basic R statistics (e.g. mean, min), as well as slope. 
Additional aggregate statistics can be created using the format function(x) 
(...). See FUN in \code{\link{apply}} for more detail.}

\item{type}{"absolute" or "relative", whether you wish the climate window to be relative
(e.g. the number of days before each biological record is measured) or absolute
(e.g. number of days before a set point in time).}

\item{refday}{If type is absolute, the day and month respectively of the 
year from which the absolute window analysis will start.}

\item{cinterval}{The resolution at which climate window analysis will be 
conducted. May be days ("day"), weeks ("week"), or months ("month"). Note the units 
of parameter 'range' will differ depending on the choice 
of cinterval}

\item{cmissing}{cmissing Determines what should be done if there are 
missing climate data. Three approaches are possible: 
 - FALSE; the function will not run if missing climate data is encountered.
 An object 'missing' will be returned containing the dates of missing climate.
 - "method1"; missing climate data will be replaced with the mean climate
 of the preceding and following 2 days.
 - "method2"; missing climate data will be replaced with the mean climate
 of all records on the same date.}

\item{spatial}{A list item containing:
1. A factor that defines which spatial group (i.e. population) each biological
record is taken from. The length of this factor should correspond to the length 
of the biological dataset.
2. A factor that defines which spatial group (i.e. population) climate data
corresponds to. This length of this factor should correspond to the length of
the climate dataset.}

\item{cohort}{A variable used to group biological records that occur in the same biological
season but cover multiple years (e.g. southern hemisphere breeding season). By default,
autowin will use year (extracted from parameter bdate) as the cohort variable. 
The cohort variable should be in the same dataset as the variable bdate.}

\item{cutoff.day, cutoff.month}{Redundant parameters. Now replaced by refday.}

\item{furthest, closest}{Redundant parameters. Now repalced by range.}
}
\value{
Will return a dataframe containing the correlation between the two
 climate variables.
}
\description{
Test the correlation between two climate variables.
}
\examples{
\dontrun{
# Test correlation between temperature and rainfall in the MassClimate dataset.

data(Mass)
data(MassClimate)

cross <- crosswin(xvar = list(Temp = MassClimate$Temp), 
                 xvar2 = list(Rain = MassClimate$Rain), 
                 cdate = MassClimate$Date, bdate = Mass$Date, 
                 range = c(365, 0),
                 stat = "mean", stat2 = "mean", type = "relative",
                 cmissing = FALSE, cinterval = "day")
                
# View the output
head(cross)

# Plot the output
plotcor(cross, type = "C")

}

}
\author{
Liam D. Bailey and Martijn van de Pol
}

