\name{update.emaxsimobj}
\alias{update.emaxsimobj}

\title{Update estimation in a data set generated by emaxsim }
\description{
Allows re-estimation for a data set generated by emaxsim using a
different starting value.  Typically used to test different starting
values when nls has failed to converge.
}
\usage{
\method{update}{emaxsimobj}(object, new.parm, modType=object$modType,...)
}

\arguments{
  \item{object}{ Extracted simulation object  }
  \item{new.parm}{New starting value for Emax estimation.  Must have
order (ed50,emax,e0) }
 \item{modType}{When modType=4, the fitting begins with the 4
parameter model.  If estimation fails or modType=3, the 3-parameter estimation
 is applied.  If it fails, a best-fitting model linear in its parameters is
selected.}
  \item{\dots}{ No other parameters currently used. }
}

\value{
A list is returned with class(emaxsimobj).  It has the same format as
those 
extracted by object[ ] }

\author{Neal Thomas}

\seealso{\code{\link{emaxsim}}}
\examples{

\dontrun{

## emaxsim changes the random number seed
nsim<-50
idmax<-5
doselev<-c(0,5,25,50,100)
n<-c(78,81,81,81,77)

### population parameters for simulation
e0<-2.465375 
ed50<-67.481113 
emax<-15.127726
sdy<-7.967897
pop<-c(log(ed50),emax,e0)    
meanlev<-emaxfun(doselev,pop)  

###FixedMean is specialized constructor function for emaxsim
gen<-FixedMean(n,doselev,meanlev,sdy)  
D1 <- emaxsim(nsim,gen)
e49<-D1[49]

#### re-try estimation starting at the population value
e49u<- update(e49,pop)
}
\dontshow{
## emaxsim changes the random number seed
nsim<-3
doselev<-c(0,5,25,50,100)
n<-c(78,81,81,81,77)

### population parameters for simulation
e0<-2.465375 
ed50<-67.481113 
emax<-15.127726
sdy<-7.967897
pop<-c(log(ed50),emax,e0)    
meanlev<-emaxfun(doselev,pop)  

###FixedMean is specialized constructor function for emaxsim
gen<-FixedMean(n,doselev,meanlev,sdy)  
D1 <- emaxsim(nsim,gen,nproc=1)
e3<-D1[3]

#### re-try estimation starting at the population value
e3u<- update(e3,pop)
}
}
\keyword{nonlinear}

