% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-utility.R
\name{knitPrintClinDataReview}
\alias{knitPrintClinDataReview}
\title{Include output from clinical data, or list 
of such outputs in a Rmarkdown report, with an appropriate title.}
\usage{
knitPrintClinDataReview(list, sep = ".", level = 1)
}
\arguments{
\item{list}{Named list of clinical data plots,
the names are used for the section header.
If several section header should be created, either:
\itemize{
\item{a list of level 1 named by the different group elements,
separated by \code{sep}, e.g. 
\code{list('group1.param1' = .., 'group1.param2' = ...)}.
Such list is e.g. created with \code{\link[plyr]{dlply}}.}
\item{a nested list, named with the different groups,
e.g. created with \code{lapply}}
}}

\item{sep}{String with separator used to distinguish 
different levels in the labels of the list.
e.g. '.' by default.}

\item{level}{Integer with base level for section,
1 by default.}
}
\value{
No returned value, the plots are included in the
report.
If a element in the list are empty (NULL), these elements
(and the associated sections) are not included in the report.
}
\description{
Include output from clinical data, or list 
of such outputs in a Rmarkdown report, with an appropriate title.
}
\seealso{
Other clinical data reporting: 
\code{\link{checkReportTitles}()},
\code{\link{forceParams}()},
\code{\link{getMdHeader}()},
\code{\link{getParamsFromConfig}()},
\code{\link{gitbook_clinDataReview_report}()},
\code{\link{html_clinDataReview_report}()},
\code{\link{postProcessReport}()},
\code{\link{render_clinDataReviewReport}()}
}
\author{
Laure Cougnaud
}
\concept{clinical data reporting}
