% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_creat.R
\name{calc_creat}
\alias{calc_creat}
\title{Estimate serum creatinine}
\usage{
calc_creat(sex = NULL, age = NULL, digits = 1)
}
\arguments{
\item{sex}{sex, either `male` or `female`}

\item{age}{age in years}

\item{digits}{number of digits to round to}
}
\description{
Calculate an estimated serum creatinine. Function takes vectorized input as well.
}
\details{
Uses equations described in Ceriotti et al. Clin Chem. 2008, and Junge W et al.
Clin Chim Acta. 2004. For age 15-18, a linear interpolation is used between
equations for <15 and >18 years as described in Johanssen A et al. Ther Drug
Monit 2011.
}
\examples{
calc_creat(sex = "male", age = 40)
calc_creat(sex = "male", age = c(10, 17, 60))
}
