% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_by.r
\name{cut_by}
\alias{cut_by}
\title{Convert Numeric to Factor}
\usage{
cut_by(
  x,
  breaks,
  breaks_as_quantiles = FALSE,
  labels = NULL,
  label_type = "ori",
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{breaks}{A numeric vector of internal cut points. If \code{breaks_as_quantiles} is TRUE, this
is a proportion of the data. See \code{Details}.}

\item{breaks_as_quantiles}{If TRUE, \code{breaks} is interpreted as a proportion of the data.}

\item{labels}{A vector of labels for the resulting factor levels.}

\item{label_type}{If \code{labels} is \code{NULL}, this sets the label type. \code{"ori"} for original labels,
\code{"LMH"} for "Low Medium High" style. \code{"combined"} labels that combine \code{"LMH"} type or provided \code{labels}
with the original range labels.}

\item{...}{Other arguments passed to \code{base::cut()}.}
}
\value{
A factor.
}
\description{
Divide numeric data into different groups. Easier to use than \code{base::cut()}.
}
\details{
\code{cut_by()} is a wrapper for \code{base::cut()}. Compared with the argument \code{breaks} in \code{base::cut()},
\code{breaks} here automatically sets the minimum and maximum to \code{-Inf} and \code{Inf}.
}
\note{
The argument \code{right} in \code{base::cut()} is always set to \code{FALSE}, which means the levels follow the
left closed right open convention.
}
\examples{
set.seed(123)
cut_by(rnorm(100), c(0, 1, 2))
cut_by(rnorm(100), c(1 / 3, 2 / 3), breaks_as_quantiles = TRUE, label_type = "LMH")
}
