% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{na_max}
\alias{na_max}
\alias{na_min}
\title{Safe min and max functions that return NA if all values are NA}
\usage{
na_max(x, na.rm = TRUE)

na_min(x, na.rm = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{A logical value indicating whether to remove \code{NA} values before computation.
Defaults to \code{TRUE} instead of \code{FALSE} in base R functions.}
}
\value{
The minimum or maximum value of the vector or \code{NA} if all values are \code{NA}.
}
\description{
Instead of returning \code{-Inf} or \code{Inf}, returns \code{NA} if all values are \code{NA}.
It also ignores \code{NA} values by default, which is different from base R functions.
This is useful when summarizing data frames with \code{dplyr::summarise()}.
}
\examples{
na_max(c(1, 2, 3, NA))
na_min(c(NA, NA, NA))
}
