% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geno_freq_polygenic.R
\name{geno_freq_polygenic}
\alias{geno_freq_polygenic}
\title{Genotype frequencies for the hypergeometric polygenic model}
\usage{
geno_freq_polygenic(n_loci, annotate = FALSE)
}
\arguments{
\item{n_loci}{A positive integer, interpreted as the number of biallelic
genetic loci that contribute to the polygene.  The polygene will have
\code{2*n_loci + 1} genotypes, so \code{n_loci} is typically fairly small, e.g. \code{4}.}

\item{annotate}{A logical flag.  When \code{FALSE} (the default), the function
returns a vector suitable to be used as the \code{geno_freq} argument of
\code{\link{pedigree_loglikelihood}}.  When \code{TRUE}, the function adds a
\code{names} attribute to this vector to indicate which element corresponds to
which genotype.}
}
\value{
A vector of strictly positive numbers (the genotype frequencies)
that sum to \code{1}, named with the genotype names if \code{annotate} is \code{TRUE}.
}
\description{
A function to calculate the genotype frequencies for the hypergeometric
polygenic model of (Cannings et al., 1978), see Section 8.9 of (Lange, 2002)
for a nice description of this model.
}
\details{
The hypergeometric polygenic model
(Cannings et al., 1978; Lange, 2002) is a computationally feasible
genetic model that approximates the combined effect of a given number
(\code{n_loci}) of unlinked biallelic genetic loci.  This model is often used to model
the effect of such loci on a trait when the alleles at these loci either
increase the trait by a certain, locus-independent amount (if a 'positive'
allele) or decrease
the trait by the same amount (if a 'negative' allele), with 'positive' and
'negative' alleles equally likely at each locus.  In this case, the only
relevant aspect of the \code{3 ^ n_loci} possible joint genotypes is the total number
of 'positive' alleles, so the possible genotypes of
the hypergeometric polygenic model are taken to be \code{0:(2*n_loci)}.
The transmission probabilities and genotype frequencies of the hypergeometric
polygenic model approximate these quantities for the combination of the \code{n_loci}
biallelic genetic loci described above.  Under this model, the polygenic
genotype for each person is approximately normally distributed, and these
genotypes are correlated within families with correlation coefficients
(in non-inbred families) equal to the kinship coefficients (Lange, 2002).

Setting \code{annotate} to \code{TRUE} names each element of the output vector with
the corresponding genotype. The \code{annotate} option must be set to \code{FALSE}
if the output of this function is to be used as the \code{geno_freq} argument of
\code{\link{pedigree_loglikelihood}}.
}
\examples{
geno_freq_polygenic(4, annotate = TRUE)
sum(geno_freq_polygenic(4))

}
\references{
Cannings C, Thompson E, Skolnick M. Probability functions
on complex pedigrees. Advances in Applied Probability, 1978;10(1):26-61.

Lange K.  Mathematical and Statistical Methods for Genetic Analysis
(second edition). Springer, New York. 2002.
}
