% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weekday.R
\name{weekday_factor}
\alias{weekday_factor}
\title{Convert a weekday to an ordered factor}
\usage{
weekday_factor(x, ..., labels = "en", abbreviate = TRUE, encoding = "western")
}
\arguments{
\item{x}{\verb{[weekday]}

A weekday vector.}

\item{...}{These dots are for future extensions and must be empty.}

\item{labels}{\verb{[clock_labels / character(1)]}

Character representations of localized weekday names, month names, and
AM/PM names. Either the language code as string (passed on to
\code{\link[=clock_labels_lookup]{clock_labels_lookup()}}), or an object created by \code{\link[=clock_labels]{clock_labels()}}.}

\item{abbreviate}{\verb{[logical(1)]}

If \code{TRUE}, the abbreviated weekday names from \code{labels} will be used.

If \code{FALSE}, the full weekday names from \code{labels} will be used.}

\item{encoding}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"western"}: Encode the weekdays as an ordered factor with levels from
Sunday -> Saturday.
\item \code{"iso"}: Encode the weekdays as an ordered factor with levels from
Monday -> Sunday.
}}
}
\value{
An ordered factor representing the weekdays.
}
\description{
\code{weekday_factor()} converts a weekday object to an ordered factor. This
can be useful in combination with ggplot2, or for modeling.
}
\examples{
x <- weekday(1:7)

# Default to Sunday -> Saturday
weekday_factor(x)

# ISO encoding is Monday -> Sunday
weekday_factor(x, encoding = "iso")

# With full names
weekday_factor(x, abbreviate = FALSE)

# Or a different language
weekday_factor(x, labels = "fr")
}
