% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-weekday.R
\name{year-month-weekday-narrow}
\alias{year-month-weekday-narrow}
\alias{calendar_narrow.clock_year_month_weekday}
\title{Narrow: year-month-weekday}
\usage{
\method{calendar_narrow}{clock_year_month_weekday}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_year_month_weekday]}

A year-month-weekday vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"month"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} narrowed to the supplied \code{precision}.
}
\description{
This is a year-month-weekday method for the \code{\link[=calendar_narrow]{calendar_narrow()}} generic. It
narrows a year-month-weekday vector to the specified \code{precision}.
}
\examples{
# Day precision
x <- year_month_weekday(2019, 1, 1, 2)
x

# Narrowed to month precision
calendar_narrow(x, "month")
}
