/*
 * Decompiled with CFR 0.152.
 */
package ppe.ompi;

import javax.swing.JOptionPane;
import nbl.utilj.GuiUtil;
import ppe.ExceptionHandler;
import ppe.Services;
import ppe.ec2.Ec2Wrangler;
import ppe.ec2.IncompleteNetworkSpecException;
import ppe.ec2.NetworkInfo;
import ppe.ec2.NetworkSpec;
import ppe.ec2.NiM;
import ppe.gui.InProgressFrame;
import ppe.gui.PPEManager;
import ppe.gui.networkspec.NetworkSpecGui;
import ppe.ompi.OmpiConfigServices;
import ppe.ompi.OmpiSpec;
import ppe.ompi.ParamsOmpi;

public class OmpiPPEManager
extends PPEManager {
    public static final String GUI_FRAME_TITLE = "ppe-ompi";

    public OmpiPPEManager(String[] argv, boolean shutdownAppOnExit) throws Exception {
        super(argv, GUI_FRAME_TITLE, shutdownAppOnExit);
        ExceptionHandler.useGui = false;
    }

    public OmpiPPEManager(String[] argv) throws Exception {
        this(argv, true);
    }

    @Override
    protected void specifyServices() {
        Services.setServicesClass(OmpiConfigServices.class);
    }

    @Override
    protected void createNetwork() throws Exception {
        InProgressFrame.showInProgress();
        NetworkSpec nS = new NetworkSpec(paramsEc2);
        nS.networkName = Ec2Wrangler.chooseNetworkName(paramsEc2);
        OmpiSpec oS = new OmpiSpec(new ParamsOmpi(this.paramHt, paramsEc2));
        NetworkSpecGui specGui = new NetworkSpecGui(this.ec2w, nS, oS);
        if (!specGui.fillSpec()) {
            return;
        }
        final NetworkSpec networkSpec = specGui.choicesToNetworkSpec();
        if (!networkSpec.isComplete()) {
            throw new IncompleteNetworkSpecException(networkSpec.listMissingParams());
        }
        final OmpiSpec specOmpi = specGui.choicesToOmpiSpec();
        new Thread(){

            @Override
            public void run() {
                try {
                    String networkID = OmpiPPEManager.this.ec2w.createNetwork(networkSpec);
                    if (!OmpiPPEManager.this.pingNetwork(networkID)) {
                        GuiUtil.warning((String[])new String[]{"There are NO usable instances."}, (String)"No usable instances");
                        return;
                    }
                    NetworkInfo ni = NiM.getForID(networkID);
                    if (ni == null) {
                        throw new RuntimeException("NO  network info for ID=" + networkID);
                    }
                    Services s = ni.getServices();
                    s.set(OmpiPPEManager.this.ec2w, networkSpec, specOmpi);
                    s.launch();
                    NiM.update(OmpiPPEManager.this.ec2w);
                }
                catch (Exception xxx) {
                    ExceptionHandler.gui(xxx);
                    GuiUtil.warning((String[])new String[]{"   Ompi may not have been configured"}, (String)"Warning");
                }
            }
        }.start();
        JOptionPane.showMessageDialog(null, new String[]{"A request for ec2 instances has been submitted to AWS.", "See the ec2 network manager window for the network's status."}, "ec2 network launch in progress", -1);
    }

    @Override
    protected void rebootInstances(String networkID) throws Exception {
        NetworkInfo ni = NiM.getForID(networkID);
        if (ni == null) {
            return;
        }
        if (GuiUtil.answerIsYes((String[])new String[]{"Reboot all instances in network", ni.getNetworkName() + " ?"}, (String)"Reboot instances")) {
            this.ec2w.rebootInstances(ni);
            NiM.update(this.ec2w);
        }
    }

    public static void main(String[] argv) throws Exception {
        OmpiPPEManager m = new OmpiPPEManager(argv);
        m.launchGui();
    }
}

