/*
 * Decompiled with CFR 0.152.
 */
package ppe.ompi;

import com.amazonaws.services.ec2.model.InstanceType;
import java.io.File;
import java.io.Serializable;
import ppe.Constants;
import ppe.ec2.InstanceStatus;
import ppe.ec2.NetworkInfo;
import ppe.ompi.ParamsOmpi;

public class OmpiSpec
implements Serializable {
    static final long serialVersionUID = Constants.SERIAL_VERSION_UID;
    public String networkName;
    public File rsaKeyPairFile;
    public int slotsPerHost;
    public boolean disableHyperthreading;
    public InstanceType instanceType;

    public OmpiSpec(ParamsOmpi params) {
        this.networkName = params.networkName;
        this.rsaKeyPairFile = params.rsaKeyPairFile;
        this.slotsPerHost = params.slotsPerHost;
        this.disableHyperthreading = params.disableHyperthreading;
        this.instanceType = params.instanceType;
    }

    public OmpiSpec() {
    }

    public OmpiSpec(ParamsOmpi params, NetworkInfo ni) {
        this(params);
        this.networkName = ni.getNetworkName();
        if (ni.instances == null) {
            return;
        }
        if (ni.instances.size() < 1) {
            return;
        }
        InstanceStatus s0 = ni.instances.get(0);
        this.instanceType = s0.getInstanceType();
    }

    public boolean isComplete() {
        return this.networkName != null && this.rsaKeyPairFile != null && this.slotsPerHost > 0 && this.instanceType != null;
    }

    public String listMissingParams() {
        return "Missing params: " + (this.networkName == null ? "networkName " : "") + (this.rsaKeyPairFile == null ? "rsaKeyPairFile " : "") + (this.slotsPerHost <= 0 ? "slotsPeHost " : "") + (this.instanceType == null ? "instanceType " : "");
    }

    public OmpiSpec cloneSpec() {
        OmpiSpec c = new OmpiSpec();
        c.networkName = this.nns(this.networkName);
        c.rsaKeyPairFile = this.rsaKeyPairFile != null ? new File(this.rsaKeyPairFile.getPath()) : null;
        c.slotsPerHost = this.slotsPerHost;
        c.disableHyperthreading = this.disableHyperthreading;
        c.instanceType = this.instanceType;
        return c;
    }

    private String nns(String x) {
        if (x != null) {
            return new String(x);
        }
        return null;
    }
}

