/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.Region;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.s3.AmazonS3Client;
import com.norbl.cbp.ppe.ConstantsPPE;
import com.norbl.cbp.ppe.ParamHtPPE;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.util.aws.S3Access;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class AmiPPE
implements Serializable {
    static final long serialVersionUID = ConstantsPPE.SERIAL_VERSION_UID;
    public String amiID;
    public double imageCharge;
    public transient Image image;
    public transient Region region;
    public HashMap<String, String> tags;

    public AmiPPE(String amiID, double imageCharge) {
        this.amiID = amiID;
        this.imageCharge = imageCharge;
        this.tags = new HashMap();
    }

    public boolean isUsableReBilling(ParamsEc2 params) {
        if (this.imageCharge <= 0.0) {
            return true;
        }
        return params.uid != null;
    }

    public String getID() {
        return this.amiID;
    }

    public String getName() {
        if (this.tags != null) {
            return this.tags.get(ATag.name.key);
        }
        return " ";
    }

    public String getTagVal(ATag aTag) {
        return this.tags.get(aTag.key);
    }

    public Region getRegion() {
        return this.region;
    }

    public String getVirtualizationType() {
        if (this.image != null) {
            return this.image.getVirtualizationType();
        }
        return null;
    }

    public boolean isParavirtual() {
        return this.image.getVirtualizationType().equals("paravirtual");
    }

    public boolean isHvm() {
        return this.image.getVirtualizationType().equals("hvm");
    }

    private void recordTags(List<Tag> tgs) {
        for (Tag t : tgs) {
            this.tags.put(t.getKey(), t.getValue());
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.amiID + " " + this.tags.get(ATag.name.key) + " " + this.imageCharge + " " + this.region.getRegionName() + " " + this.getVirtualizationType() + " \n");
        for (String key : this.tags.keySet()) {
            s.append("  " + key + "=" + this.tags.get(key) + "\n");
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getImageInfo(AmazonEC2Client ec2Client, List<AmiPPE> amis) {
        ArrayList<String> amiIDs = new ArrayList<String>();
        for (AmiPPE ami : amis) {
            amiIDs.add(ami.amiID);
        }
        try {
            DescribeRegionsResult rr = ec2Client.describeRegions();
            for (Region region : rr.getRegions()) {
                ec2Client.setEndpoint(region.getEndpoint());
                List azs = ec2Client.describeAvailabilityZones().getAvailabilityZones();
                AmiPPE.getImageInfoRegion(ec2Client, region, amis, amiIDs);
            }
        }
        finally {
            ec2Client.setEndpoint("ec2.amazonaws.com");
        }
    }

    private static void getImageInfoRegion(AmazonEC2Client ec2Client, Region region, List<AmiPPE> amis, List<String> amiIDs) {
        DescribeImagesRequest q = new DescribeImagesRequest();
        q = q.withImageIds(amiIDs);
        try {
            DescribeImagesResult r = ec2Client.describeImages(q);
            List images = r.getImages();
            for (AmiPPE ap : amis) {
                Image image = AmiPPE.getImage(images, ap.amiID);
                if (image == null) continue;
                ap.image = image;
                ap.region = region;
            }
        }
        catch (AmazonServiceException ax) {
            // empty catch block
        }
    }

    private static Image getImage(List<Image> images, String amiID) {
        for (Image img : images) {
            if (!img.getImageId().equals(amiID)) continue;
            return img;
        }
        return null;
    }

    public static void getTags(List<AmiPPE> amis) {
        for (AmiPPE ami : amis) {
            List tags = ami.image.getTags();
            ami.recordTags(tags);
        }
    }

    public static List<AmiPPE> createAmiPPEs(AmazonEC2Client ec2Client, String[] amiIDs, double imageCharge) {
        ArrayList<AmiPPE> aps = new ArrayList<AmiPPE>();
        for (String amiID : amiIDs) {
            aps.add(new AmiPPE(amiID, imageCharge));
        }
        AmiPPE.getImageInfo(ec2Client, aps);
        AmiPPE.getTags(aps);
        return aps;
    }

    public static void createAndUploadAmiPPEs(AmazonEC2Client ec2Client, S3Access s3Access, String amiGroupName, String[] amiIDs, double imageCharge) {
        List<AmiPPE> aps = AmiPPE.createAmiPPEs(ec2Client, amiIDs, imageCharge);
        for (AmiPPE ap : aps) {
            System.out.println(ap);
        }
        s3Access.putObject("norbl-ppe-info", amiGroupName, (Serializable)((Object)aps), true);
    }

    public static void uploadAmiPPEs(S3Access s3Access, String amiGroupName, List<AmiPPE> amiPPEs) {
        s3Access.putObject("norbl-ppe-info", amiGroupName, (Serializable)((Object)amiPPEs), true);
    }

    public static void createAndUploadAmiPPEs(String amiGroupName, String[] amiIDs, double imageCharge) throws Exception {
        String cf = "/home/moi/eh/aws/nbl_account/nbl.ppe-config";
        ParamHtPPE pht = new ParamHtPPE(new String[]{"configFile=" + cf});
        ParamsEc2 pec2 = new ParamsEc2(pht);
        AmazonEC2Client ec2Client = new AmazonEC2Client(pec2.buildAWSCredentials());
        AmazonS3Client s3Client = new AmazonS3Client(pec2.buildAWSCredentials());
        S3Access s3a = new S3Access(s3Client);
        AmiPPE.createAndUploadAmiPPEs(ec2Client, s3a, amiGroupName, amiIDs, imageCharge);
    }

    public static List<AmiPPE> retrieveAmiPPEs(S3Access s3Access, String amiGroupName) {
        return (List)s3Access.getObject("norbl-ppe-info", amiGroupName);
    }

    public static List<AmiPPE> retrieveAndInitAmiPPEs(S3Access s3Access, String amiGroupName, AmazonEC2Client aec) {
        List<AmiPPE> amis = AmiPPE.retrieveAmiPPEs(s3Access, amiGroupName);
        ArrayList<String> IDs = new ArrayList<String>();
        for (AmiPPE ami : amis) {
            IDs.add(ami.amiID);
        }
        DescribeImagesRequest req = new DescribeImagesRequest();
        req.setImageIds(IDs);
        DescribeImagesResult r = aec.describeImages(req);
        List images = r.getImages();
        for (Image img : images) {
            AmiPPE ami = AmiPPE.getForID(amis, img.getImageId());
            if (ami == null) continue;
            ami.image = img;
        }
        Collections.sort(amis, new Comparator<AmiPPE>(){

            @Override
            public int compare(AmiPPE a, AmiPPE b) {
                if (a.imageCharge > b.imageCharge) {
                    return -1;
                }
                if (a.imageCharge < b.imageCharge) {
                    return 1;
                }
                return 0;
            }
        });
        return amis;
    }

    private static AmiPPE getForID(List<AmiPPE> amis, String ID) {
        for (AmiPPE ami : amis) {
            if (!ami.amiID.equals(ID)) continue;
            return ami;
        }
        return null;
    }

    public static void createAmiPPEs(String amiGroupName, String[] amiIDs, double imageCharge) throws Exception {
        String cf = "/home/moi/eh/aws/nbl_account/nbl.ppe-config";
        ParamHtPPE pht = new ParamHtPPE(new String[]{"configFile=" + cf});
        ParamsEc2 pec2 = new ParamsEc2(pht);
        AmazonEC2Client ec2Client = new AmazonEC2Client(pec2.buildAWSCredentials());
        AmazonS3Client s3Client = new AmazonS3Client(pec2.buildAWSCredentials());
        S3Access s3a = new S3Access(s3Client);
        List<AmiPPE> aps = AmiPPE.createAmiPPEs(ec2Client, amiIDs, imageCharge);
        for (AmiPPE ap : aps) {
            System.out.println(ap);
        }
        ec2Client.shutdown();
    }

    public static class NoImageException
    extends RuntimeException {
        public NoImageException(String m) {
            super(m);
        }

        public NoImageException() {
        }
    }

    public static enum ATag {
        name("Name"),
        openMPI("Open MPI"),
        r("R"),
        linux("Linux"),
        rreval("rreval"),
        rstudio("RStudio");

        public String key;

        private ATag(String key) {
            this.key = key;
        }
    }
}

