/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.ompi;

import com.amazonaws.services.ec2.model.Region;
import com.norbl.cbp.ppe.Ec2InstanceType;
import com.norbl.cbp.ppe.NetworkSpec;
import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.Services;
import com.norbl.cbp.ppe.gui.networkspec.AmiChoiceU;
import com.norbl.cbp.ppe.gui.networkspec.NSGFrameU;
import com.norbl.cbp.ppe.gui.networkspec.NetworkSpecGui;
import com.norbl.cbp.ppe.ompi.OmpiConfigServices;
import com.norbl.cbp.ppe.ompi.OmpiSpec;
import com.norbl.cbp.ppe.ompi.ParamsOmpi;
import com.norbl.util.MissingParamsException;
import com.norbl.util.gui.GuiUtil;

public class OmpiPPEManager
extends PPEManager {
    public static final Class AMI_CHOICE_CLASS = AmiChoiceU.class;
    public static final Class NSG_FRAME_CLASS = NSGFrameU.class;
    ParamsOmpi paramsOmpi;
    OmpiSpec ompiSpec;

    public OmpiPPEManager(String[] argv, String amiGroup, Region ec2Region) throws Exception {
        super(argv, amiGroup, ec2Region);
    }

    @Override
    protected void specifyServices() {
        Services.setServicesClass(OmpiConfigServices.class);
    }

    @Override
    protected void initializeServices(NetworkSpec networkSpec, Services services) throws Exception {
        this.paramsOmpi = new ParamsOmpi(this.paramHt, paramsEc2);
        this.ompiSpec = new OmpiSpec(new ParamsOmpi(this.paramHt, paramsEc2));
        this.ompiSpec.networkName = networkSpec.networkName;
        this.ompiSpec.instanceType = networkSpec.instanceType;
        Ec2InstanceType eit = Ec2InstanceType.getEc2InstanceType(this.instanceTypes, networkSpec.instanceType);
        this.ompiSpec.slotsPerHost = eit.nCores;
        if (!this.ompiSpec.isComplete()) {
            throw new MissingParamsException("OmpiSpec is not complete:" + this.ompiSpec.listMissingParams());
        }
        ((OmpiConfigServices)services).set(this.ec2w);
        ((OmpiConfigServices)services).set(paramsEc2);
        ((OmpiConfigServices)services).set(networkSpec);
    }

    @Override
    protected NetworkSpec getFullySpecifiedNetworkSpec(String networkName) {
        try {
            NetworkSpecGui nsg = new NetworkSpecGui(this, AMI_CHOICE_CLASS, NSG_FRAME_CLASS, networkName);
            if (nsg.fillSpec()) {
                return nsg.choicesToNetworkSpec();
            }
            return null;
        }
        catch (Exception xxx) {
            GuiUtil.exceptionMessage(xxx);
            return null;
        }
    }

    @Override
    protected String getAboutAppTitle() {
        return "ppe-ompi";
    }

    @Override
    protected String getAboutAppVersion() {
        return "<html>Version 1.2<br><br><br> &copy; 2012, Barnet Wagman<br>Northbranchlogic, Inc.<html>";
    }

    @Override
    protected String getAmiWebpageUrl() {
        return "https://s3.amazonaws.com/norbl/Machine_images_ppe-ompi.html";
    }

    @Override
    protected String getManualWebpageUrl() {
        return "http://norbl.com/ppe-ompi/ppe-ompi.html";
    }
}

