/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.http;

import com.norbl.util.http.NamedVal;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class URIObj {
    public static final String UTF_8_Encoding = "UTF-8";
    public String uiDecoded;
    public String localPath;
    public String paramsString;
    public String[] localPathEls;
    public List<NamedVal> vals = new ArrayList<NamedVal>();

    public URIObj() {
    }

    public URIObj(String ui) {
        this();
        try {
            String[] flds;
            this.uiDecoded = URLDecoder.decode(ui, UTF_8_Encoding);
            if (!this.separateLocalPath(this.uiDecoded)) {
                return;
            }
            for (String fld : flds = this.paramsString.split("&")) {
                String[] pair = fld.split("=");
                if (pair == null || pair.length != 2) continue;
                this.vals.add(new NamedVal(pair[0], pair[1]));
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean hasLocalPath() {
        return this.localPath != null;
    }

    public String getParam(String paramName) {
        for (NamedVal nv : this.vals) {
            if (!nv.name.equals(paramName)) continue;
            return nv.val;
        }
        return null;
    }

    String toEncodedString() {
        try {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.vals.size(); ++i) {
                NamedVal vn = this.vals.get(i);
                s.append(vn.name + "=" + vn.val);
                if (i >= this.vals.size() - 1) continue;
                s.append("&");
            }
            return URLEncoder.encode(s.toString(), UTF_8_Encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (NamedVal nv : this.vals) {
            s.append(nv.toString());
            s.append("\n");
        }
        return s.toString();
    }

    private boolean separateLocalPath(String s) {
        int idx = s.indexOf(63);
        if (idx < 0) {
            return false;
        }
        this.localPath = s.substring(0, idx);
        this.paramsString = s.substring(idx + 1);
        this.localPathEls = this.stripDangling(this.localPath, '/').split("/");
        return true;
    }

    private String stripDangling(String s, char delim) {
        String x = s.trim();
        if (x.charAt(0) == delim) {
            x = x.substring(1);
        }
        if (x.charAt(x.length() - 1) == delim) {
            x = x.substring(0, x.length() - 2 + 1);
        }
        if (x.length() < s.length()) {
            return this.stripDangling(x, delim);
        }
        return x;
    }
}

