/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.model.InstanceType;
import com.norbl.cbp.ppe.Ec2InstanceType;
import com.norbl.util.AbstractParams;
import com.norbl.util.ImproperParamException;
import com.norbl.util.MissingParamsException;
import com.norbl.util.ParamHt;
import com.norbl.util.StringUtil;
import com.norbl.util.gui.GuiUtil;
import java.io.File;

public class ParamsEc2
extends AbstractParams {
    private String awsAccessKey;
    private String awsSecretKey;
    private String awsUserID;
    public InstanceType instanceType;
    public String imageID;
    public int nInstances = -1;
    public String keyName;
    public File rsaKeyPairFile;
    public String networkName;
    public boolean useSpotInstances = false;
    public double spotPrice = Double.NaN;
    public boolean useCluster = false;
    public String clusterGroupName;
    public boolean disableHyperthreading = true;
    public String securityGroup;
    public String uid;

    public ParamsEc2(ParamHt ht) throws Exception {
        super(ht);
        this.setParamVals();
        this.checkParamConsistency();
    }

    @Override
    protected void setParamVal(String key, String val) throws Exception {
        String value = val != null ? val.trim() : null;
        ParamName nm = ParamName.forKey(key);
        if (nm == null) {
            return;
        }
        switch (nm) {
            case awsAccessKey: {
                this.awsAccessKey = value;
                break;
            }
            case awsSecretKey: {
                this.awsSecretKey = value;
                break;
            }
            case awsUserID: {
                this.awsUserID = value;
                break;
            }
            case instanceType: {
                this.instanceType = Ec2InstanceType.getInstanceType(value);
                break;
            }
            case imageID: {
                this.imageID = value;
                break;
            }
            case nInstances: {
                this.nInstances = Integer.parseInt(value);
                break;
            }
            case keyName: {
                this.keyName = value;
                break;
            }
            case networkName: {
                this.networkName = value;
                break;
            }
            case useSpotInstances: {
                if (StringUtil.isValidBooleanFlag(value)) {
                    this.useSpotInstances = Boolean.parseBoolean(value);
                    break;
                }
                throw new ImproperParamException("If specified, useSpotInstances=<true|false>; it's value was=" + value);
            }
            case spotPrice: {
                this.spotPrice = Double.parseDouble(value);
                break;
            }
            case useCluster: {
                if (StringUtil.isValidBooleanFlag(value)) {
                    this.useCluster = Boolean.parseBoolean(value);
                } else {
                    throw new ImproperParamException("If specified, useCluster=<true|false>; it's value was=" + value);
                }
            }
            case clusterGroupName: {
                this.clusterGroupName = value;
                break;
            }
            case disableHyperthreading: {
                if (StringUtil.isValidBooleanFlag(value)) {
                    this.disableHyperthreading = Boolean.parseBoolean(value);
                } else {
                    throw new ImproperParamException("If specified, disableHyperthreading=<true|false>; it's value was=" + value);
                }
            }
            case securityGroup: {
                this.securityGroup = value;
                break;
            }
            case rsaKeyPairFile: {
                this.rsaKeyPairFile = new File(value);
                ParamsEc2.checkForReadFileAccess(this.rsaKeyPairFile);
                break;
            }
            case uid: {
                this.uid = value;
                break;
            }
        }
    }

    public AWSCredentials buildAWSCredentials() throws MissingParamsException {
        return new BasicAWSCredentials(this.awsAccessKey, this.awsSecretKey);
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public String getAWSUserID() {
        return this.awsUserID;
    }

    public String getMissingParamMessage() {
        if (this.ht.configFile != null) {
            return " not in argv or config file " + this.ht.configFile.getPath();
        }
        return " not in argv and the default config file " + ParamHt.getDefaultConfigFilePath(this.ht.configFilenameDefault) + " does not exist.";
    }

    private void checkParamConsistency() throws ImproperParamException {
        if (this.useSpotInstances && this.useCluster) {
            throw new ImproperParamException("Both useSpotInstances and  useCluster are set true.  AWS does not clusters with  spot instances.");
        }
        if (this.useSpotInstances && this.spotPrice <= 0.0) {
            throw new ImproperParamException("Use spot instances is set to true but the spot price=" + this.spotPrice + " which is invalid.");
        }
    }

    public void checkForConnectToAWSParams() throws MissingParamsException {
        if (this.awsAccessKey == null || this.awsSecretKey == null || this.awsUserID == null || this.instanceType == null || this.imageID == null || this.nInstances < 1 || this.keyName == null) {
            String cfs = this.getConfigFileSuffix();
            String s = "";
            if (this.awsAccessKey == null) {
                s = s + "The required param awsAccessKey was not specified in argv " + cfs;
            }
            if (this.awsSecretKey == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsSecretKey was not specified in argv " + cfs;
            }
            if (this.awsUserID == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                String string = s + "The required param awsUserID was not specified in argv " + cfs;
            }
        }
    }

    public void checkForCreateNetworkParams() throws MissingParamsException {
        if (this.awsAccessKey == null || this.awsSecretKey == null || this.awsUserID == null || this.instanceType == null || this.imageID == null || this.nInstances < 1 || this.keyName == null) {
            String cfs = this.getConfigFileSuffix();
            String s = "";
            if (this.awsAccessKey == null) {
                s = s + "The required param awsAccessKey was not specified in argv " + cfs;
            }
            if (this.awsSecretKey == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsSecretKey was not specified in argv " + cfs;
            }
            if (this.awsUserID == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsUserID was not specified in argv " + cfs;
            }
            throw new MissingParamsException(s);
        }
    }

    public void checkForNetworkInfoParams() throws MissingParamsException {
        if (this.awsAccessKey == null || this.awsSecretKey == null || this.awsUserID == null) {
            String cfs = "";
            String s = "";
            if (this.awsAccessKey == null) {
                s = s + "The required param awsAccessKey was not specified in argv " + cfs;
            }
            if (this.awsSecretKey == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsSecretKey was not specified in argv " + cfs;
            }
            if (this.awsUserID == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsUserID was not specified in argv " + cfs;
            }
            throw new MissingParamsException(s);
        }
    }

    public void checkForTerminateInstancesParams() throws MissingParamsException {
        if (this.awsAccessKey == null || this.awsSecretKey == null || this.awsUserID == null) {
            String cfs = this.getConfigFileSuffix();
            String s = "";
            if (this.awsAccessKey == null) {
                s = s + "The required param awsAccessKey was not specified in argv " + cfs;
            }
            if (this.awsSecretKey == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsSecretKey was not specified in argv " + cfs;
            }
            if (this.awsUserID == null) {
                if (s.length() > 0) {
                    s = s + "\n";
                }
                s = s + "The required param awsUserID was not specified in argv " + cfs;
            }
            throw new MissingParamsException(s);
        }
    }

    public boolean hasRequiredEc2LaunchParams() {
        return this.awsUserID != null && this.awsAccessKey != null && this.awsSecretKey != null && this.keyName != null;
    }

    public boolean hasNBLAuthorizationParams() {
        try {
            return this.uid != null;
        }
        catch (Exception xxx) {
            GuiUtil.exceptionMessage(xxx);
            return false;
        }
    }

    public static enum ParamName {
        awsAccessKey,
        awsSecretKey,
        awsUserID,
        instanceType,
        imageID,
        nInstances,
        keyName,
        networkName,
        useSpotInstances,
        spotPrice,
        useCluster,
        clusterGroupName,
        disableHyperthreading,
        securityGroup,
        rsaKeyPairFile,
        uid;


        public static ParamName forKey(String key) {
            try {
                return ParamName.valueOf(key);
            }
            catch (IllegalArgumentException iax) {
                for (ParamName x : ParamName.values()) {
                    if (!x.toString().toLowerCase().equals(key.toLowerCase())) continue;
                    return x;
                }
                return null;
            }
        }
    }
}

