/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util;

import java.text.NumberFormat;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;

public class StringUtil {
    public static boolean isValidBooleanFlag(String value) {
        String lv = value.toLowerCase();
        return lv.equals("true") || lv.equals("false");
    }

    public static String f1(double x) {
        NumberFormat f = NumberFormat.getInstance();
        f.setMaximumFractionDigits(1);
        f.setMinimumFractionDigits(1);
        return f.format(x);
    }

    public static String f2(double x) {
        NumberFormat f = NumberFormat.getInstance();
        f.setMaximumFractionDigits(2);
        f.setMinimumFractionDigits(2);
        return f.format(x);
    }

    public static String toCsv(List<String> strs) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < strs.size() - 1; ++i) {
            s.append(strs + ", ");
        }
        s.append(strs.get(strs.size() - 1));
        return s.toString();
    }

    public static boolean containsWhiteSpace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String toString(Throwable x) {
        return StringUtil.exceptionStackToString(x) + "\n\n" + StringUtil.getExceptionMessage(x);
    }

    public static String getExceptionMessage(Throwable x) {
        Throwable c = x.getCause();
        if (c != null && c.getMessage() != null && c.getMessage().length() > 0) {
            return c.getMessage();
        }
        return x.toString();
    }

    public static String exceptionStackToString(Throwable x) {
        if (x == null) {
            return "NULL exception!";
        }
        return StringUtil.throwableToString(x, "");
    }

    private static String throwableToString(Throwable x, String prefix) {
        String mess = x.toString() + "\n\n" + StringUtil.stackTraceToString(x.getStackTrace());
        Throwable cause = x.getCause();
        if (cause != null) {
            mess = mess + "\nCAUSE:\n" + StringUtil.throwableToString(cause, prefix + "    ");
        }
        return mess;
    }

    public static String stackTraceToString(StackTraceElement[] trace) {
        if (trace == null) {
            return "NULL stack trace.";
        }
        String s = "";
        for (int i = 0; i < trace.length; ++i) {
            s = trace[i] != null ? s + trace[i].toString() + "\n" : s + "null trace element at [" + i + "]";
        }
        return s;
    }

    public static String wordsToString(String[] words) {
        if (words.length < 1) {
            return "";
        }
        String s = words[0];
        for (int i = 1; i < words.length; ++i) {
            s = s + " " + words[i];
        }
        return s;
    }

    public static String toStringNull(Object s) {
        if (s != null) {
            return s.toString();
        }
        return "null";
    }

    public static String encrypt(SecretKey key, String s) throws Exception {
        Cipher c = Cipher.getInstance("AES");
        c.init(1, key);
        byte[] enb = c.doFinal(s.getBytes());
        Base64 b64enc = new Base64();
        return new String(b64enc.encode(enb));
    }

    public static String decrypt(SecretKey key, String en) throws Exception {
        Base64 b64enc = new Base64();
        byte[] enb = b64enc.decode(en.getBytes());
        Cipher c = Cipher.getInstance("AES");
        c.init(2, key);
        byte[] denb = c.doFinal(enb);
        return new String(denb);
    }
}

