/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.aws;

import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.util.MissingParamsException;
import com.norbl.util.aws.SDBAccessException;
import java.util.ArrayList;
import java.util.List;

public class SDBAccess {
    ParamsEc2 paramsEc2;
    AmazonSimpleDBClient sdbClient;

    public SDBAccess(ParamsEc2 paramsEc2) throws MissingParamsException {
        this.paramsEc2 = paramsEc2;
        this.sdbClient = new AmazonSimpleDBClient(paramsEc2.buildAWSCredentials());
    }

    public synchronized SelectResult getAll(String domain) {
        return this.sdbClient.select(new SelectRequest("select * from " + domain));
    }

    public synchronized String getUVal(String domain, String keyAttributeName, String keyAttributeVal, String soughtAttributeName) throws SDBAccessException {
        SelectResult r = this.sdbClient.select(new SelectRequest("select " + soughtAttributeName + " from " + domain + " where " + keyAttributeName.toString() + " = " + "'" + keyAttributeVal + "'", Boolean.valueOf(true)));
        List items = r.getItems();
        if (items.size() == 1) {
            List atts = ((Item)items.get(0)).getAttributes();
            if (atts.size() == 1) {
                return ((Attribute)atts.get(0)).getValue();
            }
            if (atts.size() == 0) {
                return null;
            }
            throw new SDBAccessException(keyAttributeName.toString() + "=" + keyAttributeVal + " has " + atts.size() + " attributes.");
        }
        if (items.size() < 1) {
            return null;
        }
        throw new SDBAccessException(keyAttributeName.toString() + "=" + keyAttributeVal + " has " + items.size() + " items.");
    }

    public synchronized void addAttributes(String domain, String itemName, List<NamedAttribute> nats) {
        ArrayList<ReplaceableAttribute> rats = new ArrayList<ReplaceableAttribute>();
        for (NamedAttribute na : nats) {
            rats.add(new ReplaceableAttribute(na.name, na.val, Boolean.valueOf(true)));
        }
        this.sdbClient.putAttributes(new PutAttributesRequest(domain, itemName, rats));
    }

    public synchronized void addAttribute(String domain, String itemName, String attributeName, String attributeVal) {
        ArrayList<ReplaceableAttribute> rats = new ArrayList<ReplaceableAttribute>();
        rats.add(new ReplaceableAttribute(attributeName, attributeVal, Boolean.valueOf(true)));
        this.sdbClient.putAttributes(new PutAttributesRequest(domain, itemName, rats));
    }

    public static class NamedAttribute {
        public String name;
        public String val;

        public NamedAttribute(String name, String val) {
            this.name = name;
            this.val = val;
        }
    }
}

