% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{check_class}
\alias{check_class}
\title{Check Argument's Class}
\usage{
check_class(x, arg_class, alt_null = FALSE, add_msg = NULL)
}
\arguments{
\item{x}{Function argument that is being asserted.}

\item{arg_class}{Class name. Usually "character", "numeric", "data.frame",
etc.}

\item{alt_null}{Logical. Should argument accept NULL value.}

\item{add_msg}{Is an additional message that can be printed over the standard
function error message. You can:
\itemize{
\item pass the names of the arguments that failed the test by using
\code{{x_names}} in the message body (e.g. "What are the \{x_names\}");
\item pass the tested class by using \code{{arg_class}} in the message body (e.g.
"I want them to be \{arg_class\})"
\item pass the classes of the arguments that failed the test by using
\code{{wrong_class}} in the message body (e.g. "\{wrong_class\} is wrong")
}}
}
\value{
If argument \code{class} is same as \code{arg_class} it returns invisible
\code{NULL}. Otherwise the function throws an error.
}
\description{
Check if argument is of proper class.
}
\keyword{internal}
