% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cb_query_builder.R
\name{phenotype}
\alias{phenotype}
\title{Define a phenotype}
\usage{
phenotype(id, value, from, to, instance = "0")
}
\arguments{
\item{id}{A single phenotype id. Possible phenotyoes can be explored using the code{\link{cb_search_phenotypes}} function}

\item{value}{The categorical value of the phenotype id defined}

\item{from}{For continuous phenotypes, the lower bound of the desired value range}

\item{to}{For continuous phenotypes, the upper bound of the desired value phenotype}

\item{instance}{The instance number of the phenotype, default 0}
}
\value{
A single phenotypes definition that cam be combined using &,| and ! operators
}
\description{
Defines a single phenotype
}
\examples{
\dontrun{
continuous_phenotype <- phenotype(id = 13, from = "2016-01-21", to = "2017-02-13")
categorical_phenotype <- phenotype(id = 4, value = "Cancer")
}

}
