% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm.R
\name{vcovCR.lm}
\alias{vcovCR.lm}
\title{Cluster-robust variance-covariance matrix for an lm object.}
\usage{
\method{vcovCR}{lm}(obj, cluster, type, target = NULL, inverse_var = NULL)
}
\arguments{
\item{obj}{Fitted model for which to calcualte the variance-covariance matrix}

\item{cluster}{Expression or vector indicating which observations belong to
the same cluster. Required for \code{lm} objects.}

\item{type}{Character string specifying which small-sample adjustment should 
be used.}

\item{target}{Optional matrix or vector describing the working
variance-covariance model used to calculate the \code{CR2} and \code{CR4}
adjustment matrices. If a vector, the target matrix is assumed to be
diagonal. If not specified, the target is taken to be an identity matrix.}

\item{inverse_var}{Optional logical indicating whether the weights used in 
fitting the model are inverse-variance. If not specified, \code{vcovCR} 
will attempt to infer a value.}
}
\value{
An object of class \code{c("vcovCR","clubSandwich")}, which consists
  of a matrix of the estimated variance of and covariances between the
  regression coefficient estimates.
}
\description{
\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix 
of a set of regression coefficient estimates from an \code{\link{lm}} object.
}
\seealso{
\code{\link{vcovCR}}
}

