% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusformula.R, R/clusnumeric.R, R/cluswilcox.R
\name{cluswilcox.test.formula}
\alias{cluswilcox.test}
\alias{cluswilcox.test.formula}
\alias{cluswilcox.test.numeric}
\title{Wilcoxon Rank Sum Test for Clustered Data}
\usage{
\method{cluswilcox.test}{formula}(formula, data = NULL, subset = NULL,
  na.action = na.omit, alternative = c("two.sided", "less", "greater"),
  mu = 0, group.x = NULL, permutation = FALSE, n.rep = 500, ...)

\method{cluswilcox.test}{numeric}(x, y = NULL, cluster = NULL,
  data = parent.frame(), alternative = c("two.sided", "less", "greater"),
  mu = 0, permutation = FALSE, n.rep = 500, ...)

cluswilcox.test(x, ...)
}
\arguments{
\item{formula}{an object of class \code{"formula"} in the
form of  \code{lhs \~ rhs}, where \code{lhs} is a numeric
variable giving the data values and \code{rhs} contains
the \code{cluster}, \code{group}, \code{stratum}, e.g.,
\code{z ~ cluster(a) + group(b) + stratum(c)}, where
\code{cluster}, \code{group}, \code{stratum} are special terms.}

\item{data}{A optional data frame.}

\item{subset}{an optional vector specifyin.csize a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen
when the data contains NAs. The  default action is to omit them.}

\item{alternative}{a character string specifying the
alternative hypothesis, must be one of "two.sided" (default),
 "greater" or "less". You can specify just the initial letter.}

\item{mu}{a number specifying an optional parameter used to
form the null hypothesis. See 'Details'.}

\item{group.x}{a character or a number, indicates which group id
is for treatment x.}

\item{permutation}{A logical, whether to use permutation test.}

\item{n.rep}{number of samples generated for permutation test.}

\item{...}{Further arguments to be passed to or from methods.}

\item{x}{A numeric vector of data values. Non-finite (e.g.,
infinite or missing) values will be omitted.}

\item{y}{An optional numeric vector of data values.}

\item{cluster}{numeric or charater vector, the id of clusters.
 If not specified, each observation will
be assigned a distinct cluster, i.e., no cluster in the data.}
}
\value{
a list with class "ctest" containing the following components:
\item{rstatistic}{the value of the signed rank statistic
 with a name describing it.}
\item{erstatistics}{Expected value clustered Wilcoxon ranksum statistic.}
\item{vrstatistics}{Variance of clustered Wilcoxon ranksum statistic.}
\item{statistics}{the value of the test statistic.}
\item{p.value}{the p-value for the test}
\item{data.name}{a character string giving the names of the data.}
\item{method}{the name of the method}
\item{balance}{a logical, indicating if the data is balanced.}
\item{n}{Total number of observations.}
\item{cn}{Total number of clusters.}
\item{adjusted}{indicator of whether adjusted signed rank statistic is used.}
}
\description{
This is the sum rank test to compare the means of scores from
two groups for clustered data. The cluster size can be either
identitical or variable. Effect of stratification on the test
is also adjusted for if in presence.

Performs one-sample Wilcoxon test on vectors of data using
large sample.

Performs one- and two-sample Wilcoxon tests on vectors of clustered data.
}
\details{
THe formula interface is only applicable for the 2-sample tests,
and vice versa.

If only \code{x} is given, or if both \code{x} and \code{y} are given,
then a Wilcoxon signed rank test of the null that the distribution of
\code{x} (in the one sample case) or of \code{x - y} (in the paried
two sample case) is symmetric about \code{mu} is performed.

By default(if \code{permutation} is not specified),
a normal approximation is used. Otherwise, a permutation test
is used.
}
\section{Methods (by class)}{
\itemize{
\item \code{formula}: formula interface for sum rank test.

\item \code{numeric}: numeric interface for signed rank test.
}}
\note{
This function is able to deal with data with
clusterentitical or variable cluster size. When the data
is unbalanced, adjusted signed rank statistic is used.
Ties are dropped in the test.
}
\examples{
data(crsd)
cluswilcox.test(z, cluster = id, data = crsd)
data(crsdUnb)
cluswilcox.test(z, cluster = id, data = crsdUnb)
## Formula interface, only for rank sum test.
data(crd)
cluswilcox.test(z ~ group(group) + cluster(id), data = crd)
data(crdStr)
cluswilcox.test(z ~ group(group) + cluster(id) + stratum(stratum), data = crdStr)
## Numeric interface, only for signed rank test.
data(crsd)
cluswilcox.test(z, cluster = id, data = crsd)
data(crsdUnb)
cluswilcox.test(z, cluster = id, data = crsdUnb)
}
\author{
Yujing Jiang

Yujing Jiang
}
\references{
Bernard Rosner, Robert J. Glynn, Mei-Ling Ting Lee(2003)
\emph{Incorporation of Clustering Effects for the Wilcoxon Rank
Sum Test: A Large-Sample Approach.} Biometrics, \bold{59}, 1089-1098.

Bernard Rosner, Robert J. Glynn, Mei-Ling Ting Lee(2006)
\emph{The Wilcoxon Signed Rank Test for Paired Comparisons of
 Clustered Data.} Biometrics, \bold{62}, 185-192.
}
\seealso{
\code{\link{cluswilcox.test.formula}}, \code{\link{cluswilcox.test.numeric}}
}

