% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust.bin.pair.R
\name{clust.bin.pair}
\alias{clust.bin.pair}
\title{Statistical test for clustered binary matched pair data}
\usage{
clust.bin.pair(ak, bk, ck, dk, method = "yang")
}
\arguments{
\item{ak}{vector containing counts per group of Success/Success results.}

\item{bk}{vector containing counts per group of Success/Failure results.}

\item{ck}{vector containing counts per group of Failure/Success results.}

\item{dk}{vector containing counts per group of Failure/Failure results.}

\item{method}{a character string specifying the method to calculate the
statistic. Must be one of "yang" (default), "durkalski", "obuchowski", "eliasziw".
A value of "mcnemar" can also be supplied for comparison.}
}
\value{
A list with class "htest" containing the following components:

\item{statistic}{the value of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{method}{the type of test applied.}
\item{data.name}{a character string giving the names of the data.}
}
\description{
A single interface for several adjustments to the mcnemar test for marginal
homogeneity that correct for clustered data.
}
\examples{

tc <- data.frame(nested.to.contingency(thyroids$x.pet, thyroids$x.spect))
clust.bin.pair(tc$ak, tc$bk, tc$ck, tc$dk, method="obuchowski")

pc <- psychiatry[, c('ah', 'bh', 'ch', 'dh')]
clust.bin.pair(pc$ah, pc$bh, pc$ch, pc$dh, method="eliasziw")

}
\references{
McNemar, Q. (1947). \emph{Note on the sampling error of the difference between correlated proportions or percentages}. Psychometrika, 12(2), 153-157.

Eliasziw, M., & Donner, A. (1991). \emph{Application of the McNemar test to non-independent matched pair data}. Statistics in medicine, 10(12), 1981-1991.

Obuchowski, N. A. (1998). \emph{On the comparison of correlated proportions for clustered data}. Statistics in medicine, 17(13), 1495-1507.

Durkalski, V. L., Palesch, Y. Y., Lipsitz, S. R., & Rust, P. F. (2003). \emph{Analysis of clustered matched-pair data}. Statistics in medicine, 22(15), 2417-2428.

Yang, Z., Sun, X., & Hardin, J. W. (2010). \emph{A note on the tests for clustered matched-pair binary data}. Biometrical journal, 52(5), 638-652.
}

