% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDRM.R
\name{fitDRM}
\alias{fitDRM}
\title{fitting dose-response model according to the identified pattern.}
\usage{
fitDRM(inputDataset, dose, response, ID, subsettingID = NULL,
  transform = c("none", "log", "sRoot", "qRoot", "boxcox"),
  addCovars = ~1, patternClusters, EDp = 0.5, addCovarsVar = TRUE,
  alpha = 0.05, na.rm = FALSE, imputationMethod = c("mean",
  "median"), nCores = 1)
}
\arguments{
\item{inputDataset}{a data frame containing the input dataset, it should at least include dose, response, and ID}

\item{dose}{either a single string or a scalar, indicating the name of the dose column or its index.}

\item{response}{either a single string or a scalar, indicating the name of the response column or its index.}

\item{ID}{either a single string or a scalar, indicating the name of the ID column or its index.}

\item{subsettingID}{a vector of ID's of the subjects, in case one wants to fit the models only to a subset of the data. Default is NULL, 
i.e., all the subjects in the inputDataset will be used.}

\item{transform}{single string indicating what kind of transform should be applied on the response data. 
It takes "none" (no transform, dafault), "log" (natural log), "sRoot (square root), and "qRoot" (cubic root), and 
"boxcox" (Box-Cox transformation).}

\item{addCovars}{formula specifying extra linear covariate, e.g., ~x1+x2}

\item{patternClusters}{a vector of the same length as the number of rows in inputData (number of subjects) indicating a 
pattern for each subject. Note that the keywords which are recognized are: "increasing", "decreasing", "flat", "complete", and 
"up down max at x" and "down up min at x", which x is one of the doses. The "flat" and "complete" patterns would not be considered.}

\item{EDp}{scalar in (0,1), indicatign with EDp should be computed, default is 0.5 (ED50).}

\item{addCovarsVar}{logical variable (TRUE as default), idicating whether the variance of the extra covariates 
preesented in  addCovars (unless it is only intercept) should also be computed or not.}

\item{alpha}{scalar in (0,1), level of significance with default alpha = 0.05.}

\item{na.rm}{logical variable indicatign whether missing values should be removed (TRUE) or not (FALSE, default)}

\item{imputationMethod}{signle string taking calues from "mean" (default), and "median", which indicates how the missing values should be
treated. "mean" would replace them with the mean of the observed ones, and "median" will use median of them for imputation.}

\item{nCores}{scalar, indicating the number of cores should be used to perform LRT and MCT tests. Default is 1 which means sequantial 
computation (no prallel computation).}
}
\value{
an object fo class fittedDRM which is a list with the following objects:
 fittedModels the outcome of DoseFinding::fitMod for all the suitable models
 estAICNonmonotone: the computed AIC for the models fitted to the subjects with a non-monotone pattern
 estEDpNonmonotone: the computed EDp for the models fitted to the subjects with a non-monotone pattern
 estAICMonmonotone: the computed AIC for the models fitted to the subjects with a monotone pattern
 estEDpMonmonotone: the computed EDp for the models fitted to the subjects with a monotone pattern
 extraCovarsMonotone: if any extra covariates are added to the model their estimates and possibly standard errors 
 (if addCovarsVar = TRUE) are gievn for subjects with monotone pattern.
extraCovarsNonmonotone: if any extra covariates are added to the model their estimates and possibly standard errors 
 (if addCovarsVar = TRUE) are gievn for subjects with non-monotone pattern.
}
\description{
function to fit several dose-response candidate models according to the identified pattern, and combine their 
results using model selection and/or model averaging.
}
\details{
Note that the dose column of the inputDataset should be a numeric variable.
}
\examples{
## gnerating data
set.seed(11)
doses2Use <-  c(0, 5, 20)
numRep2Use <- c(6, 3, 3)
generatedData <- cbind(rep(1,sum(numRep2Use)),
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), doses2Use, 
numRep2Use, 1), 
		matrix(rnorm(1*sum(numRep2Use)), sum(numRep2Use), 1))
colnames(generatedData) <- c("ID", "dose", "response", "x1")
for (iGen in 2:15){
	genData0 <- cbind(rep(iGen,sum(numRep2Use)),
MCPMod::genDFdata("logistic",c(5, 3, 10, 0.05), doses2Use, 
numRep2Use, 1), matrix(rnorm(1*sum(numRep2Use)), 
sum(numRep2Use), 1))
	colnames(genData0) <- c("ID", "dose", "response", "x1")
	generatedData <- rbind(generatedData, genData0)
}
## transforming it for clustering
toInput <- inputDataMaker(2, 3, 1, generatedData)
## general pattern clustering
generalPatternClust <- generalPatternClustering(
inputData = toInput$inputData, colsData = toInput$colsData ,
colID = toInput$colID, doseLevels = toInput$doseLevels, 
numReplications = toInput$numReplicates, na.rm = FALSE, 
imputationMethod = "mean", ORICC = "two", transform = "none",
plotFormat = "eps", LRT = TRUE, MCT = TRUE,
		adjustMethod = "BH", nPermute = 100, useSeed = NULL, 
theLeastNumberOfMethods = 2, alpha = 0.05, nCores = 1)
## fitDRM 
fittedModel <- fitDRM (inputDataset = generatedData, dose = 2, 
response = 3, ID = 1, subsettingID = NULL, 
		transform = c("none"), addCovars = ~x1, 
		patternClusters = 
generalPatternClust$clusteringORICC2Results$clusteringResultsORICC2, 
		EDp = 0.5, addCovarsVar = TRUE, alpha = 0.05, na.rm = FALSE, 
imputationMethod = c("mean"), nCores = 1)

}
\seealso{
\href{https://www.rdocumentation.org/packages/DoseFinding/versions/0.9-16/topics/fitMod}{DoseFinding}
}
\author{
Vahid Nassiri, and Yimer Wasihun
}
