\name{aucplot}
\alias{aucplot}
\title{
Generate an area under the curve plot using lattice graphics
}
\description{
This function uses the \code{\link{lattice}} function \code{\link{xyplot}} to generate an AUC plot from a valid \code{"auc"} class object (see \code{\link{auc-class}}).
}
\usage{
aucplot(x)
}

\arguments{
	\item{x}{
		a valid "auc" class object (see \code{\link{auc-class}}), normally generated by the \code{\link{aucs}} function.
	}
}

\value{No return value, called for side effects}

\references{
Merged consensus clustering to assess and improve class discovery with microarray data. Simpson TI, Armstrong JD and Jarman AP. BMC Bioinformatics 2010, 11:590.
}

\author{
Dr. T. Ian Simpson
\email{ian.simpson@ed.ac.uk}
}

\seealso{
\code{\link{consmatrix-class}}
}
\examples{
#load up a test cluscomp result
data('testcmr');

#look at the result structure
summary(testcmr);

#calculate all of the AUC values from the \code{cluscomp} result for algorithm 'kmeans'
kmeanscmr <- testcmr[grep('kmeans',names(testcmr))];
acs <- aucs(kmeanscmr);

#plot the AUC curve
aucplot(acs);
}