% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpa.did.binary.R
\name{cpa.did.binary}
\alias{cpa.did.binary}
\title{Power calculations for  difference-in-difference cluster randomized trials, dichotomous outcome}
\usage{
cpa.did.binary(
  alpha = 0.05,
  power = 0.8,
  nclusters = NA,
  nsubjects = NA,
  p = NA,
  d = NA,
  ICC = NA,
  rho_c = NA,
  rho_s = NA,
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{alpha}{The level of significance of the test, the probability of a
Type I error.}

\item{power}{The power of the test, 1 minus the probability of a Type II
error.}

\item{nclusters}{The number of clusters per condition. It must be greater than 1.}

\item{nsubjects}{The mean of the cluster sizes.}

\item{p}{The expected mean proportion at the post-test, averaged across both arms.}

\item{d}{The expected absolute difference.}

\item{ICC}{The intraclass correlation.}

\item{rho_c}{The correlation between baseline and post-test outcomes at the
cluster level. This value can be used in both cross-sectional and cohort
designs. If this quantity is unknown, a value of 0 is a conservative estimate.}

\item{rho_s}{The correlation between baseline and post-test outcomes at the
subject level. This should be used for a cohort design or a mixture of cohort
and cross-sectional designs. In a purely cross-sectional design (baseline subjects
are completely different from post-test subjects), this value should be 0.}

\item{tol}{Numerical tolerance used in root finding. The default provides
at least four significant digits.}
}
\value{
The computed argument.
}
\description{
Compute the power of a difference-in-difference cluster randomized trial design with a
binary outcome, or determine parameters to obtain a target power.
}
\details{
Exactly one of \code{alpha}, \code{power}, \code{nclusters}, \code{nsubjects},
  \code{p}, \code{d}, \code{ICC}, \code{rho_c}, and \code{rho_s} must be passed as \code{NA}.
  Note that \code{alpha} and \code{power} have non-\code{NA}
  defaults, so if those are the parameters of interest they must be
  explicitly passed as \code{NA}.
}
\section{Authors}{

Jonathan Moyer (\email{jon.moyer@gmail.com}), Ken Kleinman (\email{ken.kleinman@gmail.com})
}

\section{Note}{

  This function was inspired by work from Stephane Champely (pwr.t.test) and
  Peter Dalgaard (power.t.test). As with those functions, 'uniroot' is used to
  solve power equation for unknowns, so you may see
  errors from it, notably about inability to bracket the root when
  invalid arguments are given.
}

\examples{
# Find the number of clusters per condition needed for a trial with alpha = .05,
# power = 0.8, 50 observations per cluster, expected mean post-test proportion of .50,
# expected difference of .1, ICC = 0.05, cluster level correlation of 0.3, and subject level
# correlation of 0.7.
cpa.did.binary(nsubjects=50 ,p=.5, d=.1, ICC=.05, rho_c=.3, rho_s=.7)
#
# The result, showimg nclusters of greater than 32, suggests 33 clusters per
# condition should be used.

}
\references{
Murray D. Design and Analysis of Group-Randomized Trials. New York, NY: Oxford
University Press; 1998.
}
