% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/clusterIMmlogit.R
\name{cluster.im.mlogit}
\alias{cluster.im.mlogit}
\title{Cluster-Adjusted Standard Errors and p-Values for mlogit}
\usage{
cluster.im.mlogit(mod, dat, cluster, report = TRUE, se = FALSE,
  truncate = FALSE)
}
\arguments{
\item{mod}{A model estimated using \code{mlogit}.}

\item{dat}{The data set used to estimate \code{mod}.}

\item{cluster}{A formula of the clustering variable.}

\item{report}{Should a table of results be printed to the console?}

\item{se}{Should standard errors be returned?}

\item{truncate}{Should outlying cluster-specific beta estimates be excluded?}
}
\value{
A list with the elements
\item{p.values}{A matrix of the estimated p-values.}
\item{se}{The estimated standard errors (if requested).}
}
\description{
Computes p-values and standard errors for multinomial logit models based on cluster-specific model estimation (Ibragimov and Muller 2010). A separate model is estimated in each cluster, and then p-values are computed based on a t/normal distribution of the cluster-specific estimates.
}
\examples{
\dontrun{
# predict method of hospital admission
require(VGAMdata)
data(vtinpat)
vtinpat$hos.num <- as.numeric(vtinpat$hospital)
vtinpat$age <- as.numeric(vtinpat$age.group)
vtinpat.mlogit <- mlogit.data(vtinpat, choice = "admit", shape="wide")
vt.mod <- mlogit(admit ~ 0 | age + sex, data = vtinpat.mlogit)
summary(vt.mod)

# compute cluster-adjusted p-values (takes a while)
clust.p <- cluster.im.mlogit(vt.mod, dat=vtinpat.mlogit, cluster = ~ hos.num,
           report=TRUE, se=TRUE, truncate=TRUE)

# compute 95\% confidence intervals
ci.lo <- coefficients(vt.mod) - qt(0.975, df=13)*clust.p$se
ci.hi <- coefficients(vt.mod) + qt(0.975, df=13)*clust.p$se
ci <- cbind(ci.lo, ci.hi)
colnames(ci) <- c("95\% lower bound", "95\% upper bound")
ci
}
}
\author{
Justin Esarey
}
\references{
Ibragimov, Rustam, and Ulrich K. Muller. 2010. "t-Statistic Based Correlation and Heterogeneity Robust Inference." \emph{Journal of Business & Economic Statistics} 28(4): 453-468.
}

