% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterBS.ivreg.R
\name{cluster.bs.ivreg}
\alias{cluster.bs.ivreg}
\title{Pairs Cluster Bootstrapped p-Values For Regression With Instrumental Variables}
\usage{
cluster.bs.ivreg(mod, dat, cluster, ci.level = 0.95, boot.reps = 1000,
  stratify = FALSE, cluster.se = TRUE, report = TRUE,
  prog.bar = TRUE, output.replicates = FALSE, seed = NULL)
}
\arguments{
\item{mod}{A model estimated using \code{ivreg}.}

\item{dat}{The data set used to estimate \code{mod}.}

\item{cluster}{A formula of the clustering variable.}

\item{ci.level}{What confidence level should CIs reflect?}

\item{boot.reps}{The number of bootstrap samples to draw.}

\item{stratify}{Sample clusters only (= FALSE) or clusters and observations by cluster (= TRUE).}

\item{cluster.se}{Use clustered standard errors (= TRUE) or ordinary SEs (= FALSE) for bootstrap replicates.}

\item{report}{Should a table of results be printed to the console?}

\item{prog.bar}{Show a progress bar of the bootstrap (= TRUE) or not (= FALSE).}

\item{output.replicates}{Should the cluster bootstrap coefficient replicates be output (= TRUE) or not (= FALSE)?}

\item{seed}{Random number seed for replicability (default is NULL).}
}
\value{
A list with the elements
\item{p.values}{A matrix of the estimated p-values.}
\item{ci}{A matrix of confidence intervals.}
\item{replicates}{Optional: A matrix of the coefficient estimates from each cluster bootstrap replicate.}
}
\description{
This software estimates p-values using pairs cluster bootstrapped t-statistics for instrumental variables regression models (Cameron, Gelbach, and Miller 2008). The data set is repeatedly re-sampled by cluster, a model is estimated, and inference is based on the sampling distribution of the pivotal (t) statistic.
}
\note{
Code to estimate clustered standard errors by Mahmood Arai: http://thetarzan.wordpress.com/2011/06/11/clustered-standard-errors-in-r/. Cluster SE degrees of freedom correction = (M/(M-1)) with M = the number of clusters.
}
\examples{
\dontrun{

##############################################
# example one: predict cigarette consumption
##############################################
require(AER)
data("CigarettesSW", package = "AER") 
CigarettesSW$rprice <- with(CigarettesSW, price/cpi)
CigarettesSW$rincome <- with(CigarettesSW, income/population/cpi)
CigarettesSW$tdiff <- with(CigarettesSW, (taxs - tax)/cpi)
fm <- ivreg(log(packs) ~ log(rprice) + log(rincome) | 
    log(rincome) + tdiff + I(tax/cpi), data = CigarettesSW)

# compute pairs cluster bootstrapped p-values
cluster.bs.c <- cluster.bs.ivreg(fm, dat = CigarettesSW, cluster = ~state, report = T)


################################################
# example two: pooled IV analysis of employment
################################################
require(plm)
require(AER)
data(EmplUK)
EmplUK$lag.wage <- lag(EmplUK$wage)
emp.iv <- ivreg(emp ~ wage + log(capital+1) | output + lag.wage + log(capital+1), data = EmplUK)

# compute cluster-adjusted p-values
cluster.bs.e <- cluster.bs.ivreg(mod = emp.iv, dat = EmplUK, cluster = ~firm)

}
}
\references{
Esarey, Justin, and Andrew Menger. 2017. "Practical and Effective Approaches to Dealing with Clustered Data." \emph{Political Science Research and Methods} forthcoming: 1-35. <URL:http://jee3.web.rice.edu/cluster-paper.pdf>.

Cameron, A. Colin, Jonah B. Gelbach, and Douglas L. Miller. 2008. "Bootstrap-Based Improvements for Inference with Clustered Errors." \emph{The Review of Economics and Statistics} 90(3): 414-427. <DOI:10.1162/rest.90.3.414>.
}
\author{
Justin Esarey
}
