% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zeromq.r
\name{ZeroMQ}
\alias{ZeroMQ}
\title{Wrap C++ Rcpp module in R6 to get reliable argument matching}
\description{
This is an R6 wrapper of the C++ class in order to support R argument
matching. Ideally, Rcpp will at some point support this natively and this
file will no longer be necessary. Until then, it causes redundancy with
zeromq.cpp, but this is a small inconvenience and much less error-prone than
only relying on positional arguments.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ZeroMQ$new()}}
\item \href{#method-listen}{\code{ZeroMQ$listen()}}
\item \href{#method-connect}{\code{ZeroMQ$connect()}}
\item \href{#method-disconnect}{\code{ZeroMQ$disconnect()}}
\item \href{#method-send}{\code{ZeroMQ$send()}}
\item \href{#method-receive}{\code{ZeroMQ$receive()}}
\item \href{#method-poll}{\code{ZeroMQ$poll()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZeroMQ$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-listen"></a>}}
\if{latex}{\out{\hypertarget{method-listen}{}}}
\subsection{Method \code{listen()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZeroMQ$listen(addrs = host(), socket_type = "ZMQ_REP", sid = "default")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-connect"></a>}}
\if{latex}{\out{\hypertarget{method-connect}{}}}
\subsection{Method \code{connect()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZeroMQ$connect(address, socket_type = "ZMQ_REQ", sid = "default")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-disconnect"></a>}}
\if{latex}{\out{\hypertarget{method-disconnect}{}}}
\subsection{Method \code{disconnect()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZeroMQ$disconnect(sid = "default")}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send"></a>}}
\if{latex}{\out{\hypertarget{method-send}{}}}
\subsection{Method \code{send()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZeroMQ$send(data, sid = "default", dont_wait = FALSE, send_more = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-receive"></a>}}
\if{latex}{\out{\hypertarget{method-receive}{}}}
\subsection{Method \code{receive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZeroMQ$receive(sid = "default", dont_wait = FALSE, unserialize = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-poll"></a>}}
\if{latex}{\out{\hypertarget{method-poll}{}}}
\subsection{Method \code{poll()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZeroMQ$poll(sid = "default", timeout = -1L)}\if{html}{\out{</div>}}
}

}
}
