% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{comparison_cellDivision}
\alias{comparison_cellDivision}
\title{Split a reference scan into a grid of cells}
\arguments{
\item{x3p}{an x3p object containing a breech face scan}

\item{numCells}{number of cells to partition the breech face scan into. Must be
a perfect square (49, 64, 81, etc.)}
}
\value{
A tibble containing a numCells number of rows. Each row contains a
single cell's index of the form (row #, col #) and an x3p object containing
the breech face scan of that cell.
}
\description{
Split a reference scan into a grid of cells
}
\examples{
data(fadul1.1_processed)

cellTibble <- fadul1.1_processed \%>\%
comparison_cellDivision(numCells = 64)

head(cellTibble)

}
