% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradesc.R
\name{gradient}
\alias{gd}
\alias{gradasc}
\alias{graddsc}
\alias{gradient}
\title{Gradient descent}
\usage{
graddsc(fp, x, h = 0.001, tol = 1e-04, m = 1000)

gradasc(fp, x, h = 0.001, tol = 1e-04, m = 1000)

gd(fp, x, h = 100, tol = 1e-04, m = 1000)
}
\arguments{
\item{fp}{function representing the derivative of \code{f}}

\item{x}{an initial estimate of the minima}

\item{h}{the step size}

\item{tol}{the error tolerance}

\item{m}{the maximum number of iterations}
}
\value{
the \code{x} value of the minimum found
}
\description{
Use gradient descent to find local minima
}
\details{
Gradient descent can be used to find local minima of functions.  It
will return an approximation based on the step size \code{h} and
\code{fp}.  The \code{tol} is the error tolerance, \code{x} is the
initial guess at the minimum.  This implementation also stops after
\code{m} iterations.
}
\examples{
fp <- function(x) { x^3 + 3 * x^2 - 1 }
graddsc(fp, 0)

f <- function(x) { (x[1] - 1)^2 + (x[2] - 1)^2 }
fp <-function(x) {
    x1 <- 2 * x[1] - 2
    x2 <- 8 * x[2] - 8

    return(c(x1, x2))
}
gd(fp, c(0, 0), 0.05)
}
\seealso{
Other optimz: \code{\link{bisection}},
  \code{\link{goldsect}}, \code{\link{hillclimbing}},
  \code{\link{newton}}, \code{\link{sa}},
  \code{\link{secant}}
}

