% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptint.R
\name{adaptint}
\alias{adaptint}
\title{Adaptive Integration}
\usage{
adaptint(f, a, b, n = 10, tol = 1e-06)
}
\arguments{
\item{f}{function to integrate}

\item{a}{the a-bound of integration}

\item{b}{the b-bound of integration}

\item{n}{the maximum recursive depth}

\item{tol}{the maximum error tolerance}
}
\value{
the value of the integral
}
\description{
Adaptive integration
}
\details{
The \code{adaptint} function uses Romberg's rule to calculate the
integral of the function \code{f} over the interval from \code{a}
to \code{b}.  The parameter \code{n} sets the number of intervals
to use when evaluating.  Additional options are passed to the
function \code{f} when evaluating.
}
\examples{
f <- function(x) { sin(x)^2 + log(x) }
adaptint(f, 1, 10, n = 4)
adaptint(f, 1, 10, n = 5)
adaptint(f, 1, 10, n = 10)

}
\seealso{
Other integration: \code{\link{gaussint}},
  \code{\link{giniquintile}}, \code{\link{mcint}},
  \code{\link{midpt}}, \code{\link{revolution-solid}},
  \code{\link{romberg}}, \code{\link{simp38}},
  \code{\link{simp}}, \code{\link{trap}}

Other newton-cotes: \code{\link{giniquintile}},
  \code{\link{midpt}}, \code{\link{romberg}},
  \code{\link{simp38}}, \code{\link{simp}},
  \code{\link{trap}}
}
