% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hillclimbing.R
\name{hillclimbing}
\alias{hillclimbing}
\title{Hill climbing}
\usage{
hillclimbing(f, x, h = 1, m = 1000)
}
\arguments{
\item{f}{function representing the derivative of \code{f}}

\item{x}{an initial estimate of the minimum}

\item{h}{the step size}

\item{m}{the maximum number of iterations}
}
\value{
the \code{x} value of the minimum found
}
\description{
Use hill climbing to find the global minimum
}
\details{
Hill climbing
}
\examples{
f <- function(x) {
    (x[1]^2 + x[2] - 11)^2 + (x[1] + x[2]^2 - 7)^2
}
hillclimbing(f, c(0,0))
hillclimbing(f, c(-1,-1))
hillclimbing(f, c(10,10))

}
\seealso{
Other optimz: \code{\link{bisection}},
  \code{\link{goldsect}}, \code{\link{gradient}},
  \code{\link{newton}}, \code{\link{sa}},
  \code{\link{secant}}
}
